/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.icq;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.LinkedList;
import java.util.List;
import net.kano.joscar.LEBinaryTools;
import net.kano.joscar.Writable;
import net.kano.joscar.snaccmd.icq.AbstractIcqCmd;
import net.kano.joscar.snaccmd.icq.DetailTlv;
import net.kano.joscar.snaccmd.icq.ToIcqCmd;

public class MetaFullInfoSetCmd
extends ToIcqCmd {
    private List changeDataTlvs = new LinkedList();

    public MetaFullInfoSetCmd(long uin, int id) {
        super(uin, AbstractIcqCmd.CMD_META_SET_CMD, 2);
    }

    public void writeIcqData(OutputStream out) throws IOException {
        for (Writable item : this.changeDataTlvs) {
            item.write(out);
        }
    }

    public void setCountry(int value) throws IOException {
        this.setInt(420, value);
    }

    public void setNickName(String value) {
        this.setString(340, value);
    }

    public void setLastName(String value) {
        this.setString(330, value);
    }

    public void setFirstName(String value) {
        this.setString(320, value);
    }

    public void setEmail(String value, boolean publish) throws IOException {
        if (value == null) {
            this.changeDataTlvs.add(this.getClearTlv(350));
        } else {
            DetailTlv tlv = new DetailTlv(350);
            tlv.writeString(value);
            tlv.writeUByte(publish ? 1 : 0);
            this.changeDataTlvs.add(tlv);
        }
    }

    public void setHomeCity(String value) {
        this.setString(400, value);
    }

    public void setHomeState(String value) {
        this.setString(410, value);
    }

    public void setHomePhone(String value) {
        this.setString(630, value);
    }

    public void setHomeFax(String value) {
        this.setString(640, value);
    }

    public void setAddress(String value) {
        this.setString(610, value);
    }

    public void setCellPhone(String value) {
        this.setString(650, value);
    }

    public void setHomeZip(String value) {
        this.setString(620, value);
    }

    public void setWebAware(boolean isSet) throws IOException {
        DetailTlv tlv = new DetailTlv(760);
        tlv.writeUByte(isSet ? 1 : 0);
        this.changeDataTlvs.add(tlv);
    }

    public void setAuthorization(boolean isSet) throws IOException {
        DetailTlv tlv = new DetailTlv(780);
        tlv.writeUByte(isSet ? 1 : 0);
        this.changeDataTlvs.add(tlv);
    }

    public void setGender(int value) throws IOException {
        DetailTlv tlv = new DetailTlv(780);
        tlv.writeUByte(value);
        this.changeDataTlvs.add(tlv);
    }

    public void setHomePage(String value) {
        this.setString(531, value);
    }

    public void setBirthDay(Date birthDate) throws IOException {
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(birthDate);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        LEBinaryTools.writeUShort(out, gc.get(1));
        LEBinaryTools.writeUShort(out, gc.get(2));
        LEBinaryTools.writeUShort(out, gc.get(5));
        DetailTlv tlv = new DetailTlv(570);
        tlv.writeUShort(gc.get(1));
        tlv.writeUShort(gc.get(2));
        tlv.writeUShort(gc.get(5));
        this.changeDataTlvs.add(tlv);
    }

    public void setLanguages(int l1, int l2, int l3) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DetailTlv tlv = new DetailTlv(390);
        if (l1 == -1) {
            tlv.writeUShort(0);
        } else {
            tlv.writeUShort(l1);
        }
        if (l2 == -1) {
            tlv.writeUShort(0);
        } else {
            tlv.writeUShort(l2);
        }
        if (l3 == -1) {
            tlv.writeUShort(0);
        } else {
            tlv.writeUShort(l3);
        }
        this.changeDataTlvs.add(tlv);
    }

    public void setOriginCity(String value) {
        this.setString(800, value);
    }

    public void setOriginState(String value) {
        this.setString(810, value);
    }

    public void setOriginCountry(int value) throws IOException {
        this.setInt(820, value);
    }

    public void setWorkCity(String value) {
        this.setString(670, value);
    }

    public void setWorkState(String value) {
        this.setString(680, value);
    }

    public void setWorkPhone(String value) {
        this.setString(710, value);
    }

    public void setWorkFax(String value) {
        this.setString(720, value);
    }

    public void setWorkAddress(String value) {
        this.setString(660, value);
    }

    public void setWorkZip(String value) {
        this.setString(700, value);
    }

    public void setWorkCountry(int value) throws IOException {
        this.setInt(690, value);
    }

    public void setWorkCompany(String value) {
        this.setString(430, value);
    }

    public void setWorkDepartment(String value) {
        this.setString(440, value);
    }

    public void setWorkPosition(String value) {
        this.setString(450, value);
    }

    public void setWorkOccupationCode(int value) throws IOException {
        this.setInt(460, value);
    }

    public void setWorkWebPage(String value) {
        this.setString(730, value);
    }

    public void setNotes(String value) {
        this.setString(600, value);
    }

    public void setInterests(int[] categories, String[] interests) throws IOException {
        if (categories.length != interests.length) {
            return;
        }
        DetailTlv tlv = new DetailTlv(490);
        for (int i = 0; i < categories.length; ++i) {
            tlv.writeUShort(categories[i]);
            tlv.writeString(interests[i]);
        }
        this.changeDataTlvs.add(tlv);
    }

    public void setTimeZone(int zone) throws IOException {
        DetailTlv tlv = new DetailTlv(790);
        tlv.writeUByte(zone);
        this.changeDataTlvs.add(tlv);
    }

    private void setString(int code, String value) {
        try {
            if (value == null) {
                this.changeDataTlvs.add(this.getClearTlv(code));
            } else {
                DetailTlv result = new DetailTlv(code);
                result.writeString(value);
                this.changeDataTlvs.add(result);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void setInt(int code, int value) throws IOException {
        if (value == -1) {
            this.changeDataTlvs.add(this.getClearTlv(code));
        } else {
            DetailTlv tlv = new DetailTlv(code);
            tlv.writeUShort(value);
            this.changeDataTlvs.add(tlv);
        }
    }

    private Writable getClearTlv(int type) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DetailTlv tlv = new DetailTlv(type);
        switch (type) {
            case 420: 
            case 690: 
            case 820: {
                tlv.writeUShort(0);
                break;
            }
            case 390: {
                tlv.writeUShort(0);
            }
            case 380: {
                tlv.writeUByte(0);
            }
            case 570: {
                tlv.writeUShort(0);
                tlv.writeUShort(0);
                tlv.writeUShort(0);
            }
            case 460: {
                tlv.writeUShort(0);
            }
            case 490: {
                tlv.writeUShort(0);
                tlv.writeString("");
            }
            case 790: {
                tlv.writeUByte(0);
            }
            default: {
                tlv.writeString("");
            }
        }
        return tlv;
    }
}

