/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.awt.Font;
import java.awt.Paint;
import org.jrobin.core.Util;
import org.jrobin.graph.ImageParameters;
import org.jrobin.graph.ImageWorker;
import org.jrobin.graph.RrdGraph;
import org.jrobin.graph.RrdGraphConstants;
import org.jrobin.graph.RrdGraphDef;

class ValueAxisLogarithmic
implements RrdGraphConstants {
    private static final double[][] yloglab = new double[][]{{1.0E9, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {1000.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {10.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {10.0, 1.0, 2.5, 5.0, 7.5, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {10.0, 1.0, 2.0, 4.0, 6.0, 8.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}, {10.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0}};
    private RrdGraph rrdGraph;
    private ImageParameters im;
    private ImageWorker worker;
    private RrdGraphDef gdef;

    ValueAxisLogarithmic(RrdGraph rrdGraph) {
        this.rrdGraph = rrdGraph;
        this.im = rrdGraph.im;
        this.gdef = rrdGraph.gdef;
        this.worker = rrdGraph.worker;
    }

    boolean draw() {
        int n;
        int n2;
        double d;
        int n3;
        Font font = this.gdef.smallFont;
        Paint paint = this.gdef.colors[4];
        Paint paint2 = this.gdef.colors[5];
        Paint paint3 = this.gdef.colors[6];
        int n4 = (int)Math.ceil(this.rrdGraph.getSmallFontHeight());
        int n5 = (int)(this.worker.getFontAscent(font) / 2.0);
        double d2 = (double)this.im.ysize / (Math.log10(this.im.maxval) - Math.log10(this.im.minval));
        if (Double.isNaN(d2)) {
            return false;
        }
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        while (yloglab[n8][0] > 0.0) {
            double d3;
            double d4 = Math.log10(yloglab[n8][0]);
            n3 = 1;
            while (yloglab[n8][n3 + 1] > 0.0) {
                if (yloglab[n8][n3 + 2] == 0.0) {
                    d4 = Math.log10(yloglab[n8][n3 + 1]) - Math.log10(yloglab[n8][n3]);
                    break;
                }
                ++n3;
            }
            if ((d3 = d2 * d4) > 5.0) {
                n6 = n8;
            }
            if (d3 > (double)(2 * n4)) {
                n7 = n8;
            }
            ++n8;
        }
        n8 = this.im.xorigin;
        n3 = n8 + this.im.xsize;
        for (d = Math.pow(10.0, Math.log10(this.im.minval) - Math.log10(this.im.minval) % Math.log10(yloglab[n6][0])); d <= this.im.maxval; d *= yloglab[n6][0]) {
            if (d < this.im.minval) continue;
            n2 = 0;
            while (yloglab[n6][++n2] > 0.0 && (n = this.rrdGraph.mapper.ytr(d * yloglab[n6][n2])) > this.im.yorigin - this.im.ysize) {
                this.worker.drawLine(n8 - 1, n, n8 + 1, n, paint, TICK_STROKE);
                this.worker.drawLine(n3 - 1, n, n3 + 1, n, paint, TICK_STROKE);
                this.worker.drawLine(n8, n, n3, n, paint, GRID_STROKE);
            }
        }
        for (d = Math.pow(10.0, Math.log10(this.im.minval) - Math.log10(this.im.minval) % Math.log10(yloglab[n7][0])); d <= this.im.maxval; d *= yloglab[n7][0]) {
            if (d < this.im.minval) continue;
            n2 = 0;
            while (yloglab[n7][++n2] > 0.0 && (n = this.rrdGraph.mapper.ytr(d * yloglab[n7][n2])) > this.im.yorigin - this.im.ysize) {
                this.worker.drawLine(n8 - 2, n, n8 + 2, n, paint2, TICK_STROKE);
                this.worker.drawLine(n3 - 2, n, n3 + 2, n, paint2, TICK_STROKE);
                this.worker.drawLine(n8, n, n3, n, paint2, GRID_STROKE);
                String string = Util.sprintf("%3.0e", d * yloglab[n7][n2]);
                int n9 = (int)this.worker.getStringWidth(string, font);
                this.worker.drawString(string, n8 - n9 - 7, n + n5, font, paint3);
            }
        }
        return true;
    }
}

