/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.core.jrrd;

import java.io.IOException;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import org.jrobin.core.jrrd.CDPStatusBlock;
import org.jrobin.core.jrrd.ConsolidationFunctionType;
import org.jrobin.core.jrrd.DataChunk;
import org.jrobin.core.jrrd.RRDFile;
import org.jrobin.core.jrrd.RRDatabase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Archive {
    RRDatabase db;
    long offset;
    long dataOffset;
    long size;
    ConsolidationFunctionType type;
    int rowCount;
    int pdpCount;
    double xff;
    ArrayList<CDPStatusBlock> cdpStatusBlocks;
    int currentRow;
    private double[][] values;

    Archive(RRDatabase rRDatabase) throws IOException {
        this.db = rRDatabase;
        RRDFile rRDFile = rRDatabase.rrdFile;
        this.offset = rRDFile.getFilePointer();
        this.type = ConsolidationFunctionType.get(rRDFile.readString(20));
        this.rowCount = rRDFile.readInt();
        this.pdpCount = rRDFile.readInt();
        rRDFile.align();
        this.xff = rRDFile.readDouble();
        rRDFile.align();
        rRDFile.skipBytes(72);
        this.size = rRDFile.getFilePointer() - this.offset;
    }

    public ConsolidationFunctionType getType() {
        return this.type;
    }

    void loadCDPStatusBlocks(RRDFile rRDFile, int n) throws IOException {
        this.cdpStatusBlocks = new ArrayList();
        for (int i = 0; i < n; ++i) {
            this.cdpStatusBlocks.add(new CDPStatusBlock(rRDFile));
        }
    }

    public CDPStatusBlock getCDPStatusBlock(int n) {
        return this.cdpStatusBlocks.get(n);
    }

    public Iterator<CDPStatusBlock> getCDPStatusBlocks() {
        return this.cdpStatusBlocks.iterator();
    }

    void loadCurrentRow(RRDFile rRDFile) throws IOException {
        this.currentRow = rRDFile.readInt();
    }

    void loadData(RRDFile rRDFile, int n) throws IOException {
        this.dataOffset = rRDFile.getFilePointer();
        rRDFile.skipBytes(8 * this.rowCount * n);
    }

    DataChunk loadData(DataChunk dataChunk) throws IOException {
        Calendar calendar = Calendar.getInstance();
        Calendar calendar2 = (Calendar)calendar.clone();
        calendar2.add(5, -1);
        this.loadData(dataChunk, calendar2.getTime().getTime() / 1000L, calendar.getTime().getTime() / 1000L);
        return dataChunk;
    }

    void loadData(DataChunk dataChunk, long l, long l2) throws IOException {
        long l3 = dataChunk.start < 0 ? (long)(this.currentRow + 1) : (long)(this.currentRow + dataChunk.start + 1);
        this.db.rrdFile.ras.seek(this.dataOffset + l3 * 8L);
        double[][] dArray = dataChunk.data;
        int n = 0;
        int n2 = dataChunk.start;
        while (n2 < this.rowCount - dataChunk.end) {
            int n3;
            if (n2 < 0) {
                for (n3 = 0; n3 < dataChunk.dsCount; ++n3) {
                    dArray[n][n3] = Double.NaN;
                }
            } else if (n2 >= this.rowCount) {
                for (n3 = 0; n3 < dataChunk.dsCount; ++n3) {
                    dArray[n][n3] = Double.NaN;
                }
            } else {
                if (l3 >= (long)this.rowCount) {
                    this.db.rrdFile.ras.seek(this.dataOffset + (l3 -= (long)this.rowCount) * 8L);
                }
                for (n3 = 0; n3 < dataChunk.dsCount; ++n3) {
                    dArray[n][n3] = this.db.rrdFile.readDouble();
                }
                ++l3;
            }
            ++n2;
            ++n;
        }
    }

    void printInfo(PrintStream printStream, NumberFormat numberFormat, int n) {
        StringBuffer stringBuffer = new StringBuffer("rra[");
        stringBuffer.append(n);
        printStream.print(stringBuffer);
        printStream.print("].cf = \"");
        printStream.print(this.type);
        printStream.println("\"");
        printStream.print(stringBuffer);
        printStream.print("].rows = ");
        printStream.println(this.rowCount);
        printStream.print(stringBuffer);
        printStream.print("].pdp_per_row = ");
        printStream.println(this.pdpCount);
        printStream.print(stringBuffer);
        printStream.print("].xff = ");
        printStream.println(this.xff);
        stringBuffer.append("].cdp_prep[");
        int n2 = 0;
        for (CDPStatusBlock cDPStatusBlock : this.cdpStatusBlocks) {
            printStream.print(stringBuffer);
            printStream.print(n2);
            printStream.print("].value = ");
            double d = cDPStatusBlock.value;
            printStream.println(Double.isNaN(d) ? "NaN" : numberFormat.format(d));
            printStream.print(stringBuffer);
            printStream.print(n2++);
            printStream.print("].unknown_datapoints = ");
            printStream.println(cDPStatusBlock.unknownDatapoints);
        }
    }

    void toXml(PrintStream printStream) {
        try {
            printStream.println("\t<rra>");
            printStream.print("\t\t<cf> ");
            printStream.print(this.type);
            printStream.println(" </cf>");
            printStream.print("\t\t<pdp_per_row> ");
            printStream.print(this.pdpCount);
            printStream.print(" </pdp_per_row> <!-- ");
            printStream.print(this.db.header.pdpStep * this.pdpCount);
            printStream.println(" seconds -->");
            printStream.print("\t\t<xff> ");
            printStream.print(this.xff);
            printStream.println(" </xff>");
            printStream.println();
            printStream.println("\t\t<cdp_prep>");
            for (int i = 0; i < this.cdpStatusBlocks.size(); ++i) {
                this.cdpStatusBlocks.get(i).toXml(printStream);
            }
            printStream.println("\t\t</cdp_prep>");
            printStream.println("\t\t<database>");
            long l = -(this.rowCount - 1);
            int n = 0;
            int n2 = this.currentRow;
            this.db.rrdFile.ras.seek(this.dataOffset + (long)((n2 + 1) * 16));
            long l2 = this.db.lastUpdate.getTime() / 1000L;
            int n3 = this.db.header.pdpStep;
            DecimalFormat decimalFormat = new DecimalFormat("0.0000000000E0");
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
            while (n++ < this.rowCount) {
                if (++n2 == this.rowCount) {
                    n2 = 0;
                    this.db.rrdFile.ras.seek(this.dataOffset);
                }
                long l3 = l2 - l2 % (long)(this.pdpCount * n3) + l * (long)this.pdpCount * (long)n3;
                ++l;
                printStream.print("\t\t\t<!-- ");
                printStream.print(simpleDateFormat.format(new Date(l3 * 1000L)));
                printStream.print(" / ");
                printStream.print(l3);
                printStream.print(" --> ");
                for (int i = 0; i < this.db.header.dsCount; ++i) {
                    printStream.print("<v> ");
                    double d = this.db.rrdFile.readDouble();
                    if (Double.isNaN(d)) {
                        printStream.print("NaN");
                    } else {
                        printStream.print(decimalFormat.format(d));
                    }
                    printStream.print(" </v>");
                }
                printStream.println("</row>");
            }
            printStream.println("\t\t</database>");
            printStream.println("\t</rra>");
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage());
        }
    }

    public double[][] getValues() throws IOException {
        if (this.values != null) {
            return this.values;
        }
        this.values = new double[this.db.header.dsCount][this.rowCount];
        int n = this.currentRow;
        this.db.rrdFile.ras.seek(this.dataOffset + (long)((n + 1) * this.db.header.dsCount * 8));
        for (int i = 0; i < this.rowCount; ++i) {
            if (++n == this.rowCount) {
                n = 0;
                this.db.rrdFile.ras.seek(this.dataOffset);
            }
            for (int j = 0; j < this.db.header.dsCount; ++j) {
                double d;
                this.values[j][i] = d = this.db.rrdFile.readDouble();
            }
        }
        return this.values;
    }

    public int getPdpCount() {
        return this.pdpCount;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public double getXff() {
        return this.xff;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[Archive: OFFSET=0x");
        stringBuffer.append(Long.toHexString(this.offset));
        stringBuffer.append(", SIZE=0x");
        stringBuffer.append(Long.toHexString(this.size));
        stringBuffer.append(", type=");
        stringBuffer.append(this.type);
        stringBuffer.append(", rowCount=");
        stringBuffer.append(this.rowCount);
        stringBuffer.append(", pdpCount=");
        stringBuffer.append(this.pdpCount);
        stringBuffer.append(", xff=");
        stringBuffer.append(this.xff);
        stringBuffer.append(", currentRow=");
        stringBuffer.append(this.currentRow);
        stringBuffer.append("]");
        for (CDPStatusBlock cDPStatusBlock : this.cdpStatusBlocks) {
            stringBuffer.append("\n\t\t");
            stringBuffer.append(cDPStatusBlock.toString());
        }
        return stringBuffer.toString();
    }
}

