/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.monitor;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.partition.Partition;
import com.hazelcast.util.Clock;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistributedMemberInfoCallable
implements Callable<MemberInfo>,
Serializable,
HazelcastInstanceAware {
    private transient HazelcastInstance hazelcastInstance;

    @Override
    public MemberInfo call() throws Exception {
        MemberInfo memberInfo = new MemberInfo();
        HashSet<Integer> partitions = new HashSet<Integer>();
        for (Partition partition : this.hazelcastInstance.getPartitionService().getPartitions()) {
            if (!this.hazelcastInstance.getCluster().getLocalMember().equals(partition.getOwner())) continue;
            partitions.add(partition.getPartitionId());
        }
        memberInfo.partitions = partitions;
        memberInfo.time = Clock.currentTimeMillis();
        memberInfo.totalMemory = Runtime.getRuntime().totalMemory();
        memberInfo.freeMemory = Runtime.getRuntime().freeMemory();
        memberInfo.maxMemory = Runtime.getRuntime().maxMemory();
        memberInfo.availableProcessors = Runtime.getRuntime().availableProcessors();
        memberInfo.systemProps = System.getProperties();
        return memberInfo;
    }

    @Override
    public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
        this.hazelcastInstance = hazelcastInstance;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MemberInfo
    implements Serializable {
        private Set<Integer> partitions;
        private long time;
        private long totalMemory;
        private long freeMemory;
        public long maxMemory;
        public int availableProcessors;
        public Properties systemProps;

        public Set<Integer> getPartitions() {
            return this.partitions;
        }

        public long getTime() {
            return this.time;
        }

        public long getTotalMemory() {
            return this.totalMemory;
        }

        public long getFreeMemory() {
            return this.freeMemory;
        }

        public long getMaxMemory() {
            return this.maxMemory;
        }

        public int getAvailableProcessors() {
            return this.availableProcessors;
        }

        public Properties getSystemProps() {
            return this.systemProps;
        }
    }
}

