/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.core;

import com.hazelcast.core.ExecutionCallback;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.core.ISet;
import com.hazelcast.core.Member;
import com.hazelcast.core.MemberLeftException;
import com.hazelcast.core.PartitionAware;
import com.hazelcast.impl.DistributedRunnableAdapter;
import com.hazelcast.impl.ExecutionManagerCallback;
import com.hazelcast.impl.InnerFutureTask;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DistributedTask<V>
extends FutureTask<V> {
    private volatile V result = null;
    private volatile Throwable exception = null;
    private final Inner inner;
    private volatile boolean done = false;
    private volatile boolean passed = false;
    private volatile boolean cancelled = false;
    private volatile MemberLeftException memberLeftException = null;

    private DistributedTask(Callable<V> callable, Member member, Set<Member> members, Object key) {
        super(callable);
        if (key == null && member == null && members == null) {
            if (callable instanceof DistributedRunnableAdapter) {
                DistributedRunnableAdapter dra = (DistributedRunnableAdapter)((Object)callable);
                Runnable runnable = dra.getRunnable();
                if (runnable instanceof PartitionAware) {
                    key = ((PartitionAware)((Object)runnable)).getPartitionKey();
                }
                this.result = dra.getResult();
            } else if (callable instanceof PartitionAware) {
                key = ((PartitionAware)((Object)callable)).getPartitionKey();
            }
        }
        if (key != null) {
            this.check(key);
        }
        if (members != null) {
            if (members instanceof ISet) {
                HashSet<Member> newMembers = new HashSet<Member>();
                for (Member mem : members) {
                    newMembers.add(mem);
                }
                members = newMembers;
            }
            if (members.size() == 1) {
                Iterator<Member> i$ = members.iterator();
                while (i$.hasNext()) {
                    Member m;
                    member = m = i$.next();
                }
                members = null;
            }
        }
        this.inner = new Inner(callable, member, members, key);
    }

    private void check(Object obj) {
        if (obj == null) {
            throw new NullPointerException("Cannot be null.");
        }
        if (!(obj instanceof Serializable)) {
            throw new IllegalArgumentException(obj.getClass().getName() + " is not Serializable.");
        }
    }

    public DistributedTask(Callable<V> callable) {
        this(callable, null, null, null);
    }

    public DistributedTask(Callable<V> callable, Member member) {
        this(callable, member, null, null);
    }

    protected DistributedTask(Callable<V> callable, Set<Member> members) {
        this(callable, null, members, null);
    }

    public DistributedTask(Callable<V> callable, Object key) {
        this(callable, null, null, key);
    }

    public DistributedTask(Runnable task, V result) {
        this(DistributedTask.callable(task, result));
    }

    public DistributedTask(Runnable task, V result, Member member) {
        this(DistributedTask.callable(task, result), member);
    }

    public DistributedTask(Runnable task, V result, Set<Member> members) {
        this(DistributedTask.callable(task, result), members);
    }

    public DistributedTask(Runnable task, V result, Object key) {
        this(DistributedTask.callable(task, result), key);
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        if (!this.done || !this.passed) {
            this.inner.get();
            this.passed = true;
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        if (this.memberLeftException != null) {
            throw this.memberLeftException;
        }
        if (this.exception != null) {
            throw new ExecutionException(this.exception);
        }
        return this.result;
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        if (!this.done || !this.passed) {
            this.inner.get(timeout, unit);
            this.passed = true;
        }
        if (this.cancelled) {
            throw new CancellationException();
        }
        if (this.memberLeftException != null) {
            throw this.memberLeftException;
        }
        if (this.exception != null) {
            if (this.exception instanceof TimeoutException) {
                throw (TimeoutException)this.exception;
            }
            throw new ExecutionException(this.exception);
        }
        if (!this.done) {
            throw new TimeoutException();
        }
        return this.result;
    }

    @Override
    protected void set(V value) {
    }

    public void setExecutionCallback(ExecutionCallback<V> executionCallback) {
        this.inner.setExecutionCallback(executionCallback);
    }

    public ExecutionCallback<V> getExecutionCallback() {
        return this.inner.getExecutionCallback();
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isDone() {
        return this.done;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.done || this.cancelled) {
            return false;
        }
        this.cancelled = this.inner.cancel(mayInterruptIfRunning);
        return this.cancelled;
    }

    protected void setMemberLeft(Member member) {
    }

    public Object getInner() {
        return this.inner;
    }

    public static <V> Callable<V> callable(Runnable task, V result) {
        return new DistributedRunnableAdapterImpl<V>(task, result);
    }

    protected void onResult(V result) {
        this.result = result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DistributedRunnableAdapterImpl<V>
    implements DistributedRunnableAdapter,
    Serializable,
    Callable<V>,
    HazelcastInstanceAware {
        private static final long serialVersionUID = -4L;
        private Runnable task;
        private V result;

        public DistributedRunnableAdapterImpl(Runnable task, V result) {
            this.task = task;
            this.result = result;
        }

        @Override
        public V getResult() {
            return this.result;
        }

        @Override
        public Runnable getRunnable() {
            return this.task;
        }

        @Override
        public void setRunnable(Runnable runnable) {
            this.task = runnable;
        }

        @Override
        public V call() {
            this.task.run();
            return this.result;
        }

        @Override
        public void setHazelcastInstance(HazelcastInstance hazelcastInstance) {
            if (this.task instanceof HazelcastInstanceAware) {
                ((HazelcastInstanceAware)((Object)this.task)).setHazelcastInstance(hazelcastInstance);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Inner
    implements InnerFutureTask<V> {
        private final Callable<V> callable;
        private final Member member;
        private final Set<Member> members;
        private final Object key;
        private volatile ExecutionManagerCallback executionManagerCallback;
        private ExecutionCallback<V> executionCallback = null;

        public Inner(Callable<V> callable, Member member, Set<Member> members, Object key) {
            this.callable = callable;
            this.member = member;
            this.key = key;
            this.members = members;
        }

        public void get() throws InterruptedException, ExecutionException {
            this.executionManagerCallback.get();
        }

        public void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            this.executionManagerCallback.get(timeout, unit);
        }

        @Override
        public void innerDone() {
            DistributedTask.this.done = true;
            DistributedTask.this.done();
        }

        @Override
        public boolean isDone() {
            return DistributedTask.this.done;
        }

        @Override
        public void innerSet(V value) {
            DistributedTask.this.set(value);
            DistributedTask.this.onResult(value);
        }

        @Override
        public void innerSetException(Throwable throwable, boolean done) {
            if (done) {
                this.innerDone();
            }
            DistributedTask.this.exception = throwable;
            DistributedTask.this.setException(throwable);
        }

        @Override
        public void innerSetCancelled() {
            DistributedTask.this.cancelled = true;
            this.innerDone();
        }

        @Override
        public void innerSetMemberLeft(Member member) {
            this.innerDone();
            DistributedTask.this.memberLeftException = new MemberLeftException(member);
            DistributedTask.this.setMemberLeft(member);
        }

        @Override
        public Callable<V> getCallable() {
            return this.callable;
        }

        @Override
        public Object getKey() {
            return this.key;
        }

        @Override
        public Member getMember() {
            return this.member;
        }

        @Override
        public Set<Member> getMembers() {
            return this.members;
        }

        @Override
        public void setExecutionManagerCallback(ExecutionManagerCallback executionManagerCallback) {
            this.executionManagerCallback = executionManagerCallback;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            if (this.executionManagerCallback == null) {
                return false;
            }
            DistributedTask.this.cancelled = this.executionManagerCallback.cancel(mayInterruptIfRunning);
            if (DistributedTask.this.cancelled) {
                this.innerDone();
            }
            return DistributedTask.this.cancelled;
        }

        @Override
        public ExecutionCallback getExecutionCallback() {
            return this.executionCallback;
        }

        public void setExecutionCallback(ExecutionCallback<V> executionCallback) {
            this.executionCallback = executionCallback;
        }
    }
}

