/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack;

import java.util.LinkedList;
import org.jivesoftware.smack.Connection;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.packet.Packet;

public class PacketCollector {
    private static final int MAX_PACKETS = 65536;
    private PacketFilter packetFilter;
    private LinkedList<Packet> resultQueue;
    private Connection conection;
    private boolean cancelled = false;

    protected PacketCollector(Connection conection, PacketFilter packetFilter) {
        this.conection = conection;
        this.packetFilter = packetFilter;
        this.resultQueue = new LinkedList();
    }

    public void cancel() {
        if (!this.cancelled) {
            this.cancelled = true;
            this.conection.removePacketCollector(this);
        }
    }

    public PacketFilter getPacketFilter() {
        return this.packetFilter;
    }

    public synchronized Packet pollResult() {
        if (this.resultQueue.isEmpty()) {
            return null;
        }
        return this.resultQueue.removeLast();
    }

    public synchronized Packet nextResult() {
        while (this.resultQueue.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.resultQueue.removeLast();
    }

    public synchronized Packet nextResult(long timeout) {
        if (this.resultQueue.isEmpty()) {
            long start = System.currentTimeMillis();
            try {
                long now;
                for (long waitTime = timeout; this.resultQueue.isEmpty() && waitTime > 0L; waitTime -= now - start) {
                    this.wait(waitTime);
                    now = System.currentTimeMillis();
                    start = now;
                }
            }
            catch (InterruptedException ie) {
                // empty catch block
            }
            if (this.resultQueue.isEmpty()) {
                return null;
            }
            return this.resultQueue.removeLast();
        }
        return this.resultQueue.removeLast();
    }

    protected synchronized void processPacket(Packet packet) {
        if (packet == null) {
            return;
        }
        if (this.packetFilter == null || this.packetFilter.accept(packet)) {
            if (this.resultQueue.size() == 65536) {
                this.resultQueue.removeLast();
            }
            this.resultQueue.addFirst(packet);
            this.notifyAll();
        }
    }
}

