/*
 * Decompiled with CFR 0.152.
 */
package f00f.net.irc.martyr.replies;

import f00f.net.irc.martyr.InCommand;
import f00f.net.irc.martyr.clientstate.Channel;
import f00f.net.irc.martyr.clientstate.ClientState;
import f00f.net.irc.martyr.replies.GenericReply;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamesReply
extends GenericReply {
    static Logger log = Logger.getLogger(NamesReply.class);
    private List<String> names;
    private String channel;

    public NamesReply() {
    }

    public NamesReply(String channel, List<String> names) {
        this.names = names;
        this.channel = channel;
    }

    @Override
    public String getIrcIdentifier() {
        return "353";
    }

    @Override
    public InCommand parse(String prefix, String identifier, String params) {
        return new NamesReply(this.getParameter(params, 2), Arrays.asList(this.getParameter(params, 3).split(" ")));
    }

    @Override
    public boolean updateClientState(ClientState state) {
        boolean stateChanged = false;
        Channel channelObj = state.getChannel(this.channel);
        if (this.channel == null) {
            log.error((Object)"NamesReply: Channel is null");
            return false;
        }
        if (channelObj == null) {
            log.fatal((Object)("NamesReply: No channel object for channel: " + this.channel));
            return false;
        }
        for (String nick : this.names) {
            if (channelObj.isMemberInChannel(nick)) continue;
            channelObj.addMember(nick, (InCommand)this);
            stateChanged = true;
        }
        return stateChanged;
    }

    public List<String> getNames() {
        return this.names;
    }

    public String getChannel() {
        return this.channel;
    }
}

