/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.tools.arguments;

import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.PdfReader;
import java.io.IOException;
import java.text.DecimalFormat;
import javax.swing.table.AbstractTableModel;

public class PageTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = -3954578372030475127L;
    int numberOfPages;
    PdfReader reader;
    DecimalFormat myFormatter = new DecimalFormat("00000");

    public PageTableModel(String filename) {
        try {
            this.reader = new PdfReader(filename);
            this.numberOfPages = this.reader.getNumberOfPages();
        }
        catch (IOException ex) {
            throw new RuntimeException("File " + filename + " can't be read!");
        }
    }

    public int getColumnCount() {
        return 4;
    }

    public int getRowCount() {
        return this.numberOfPages;
    }

    public Object getValueAt(int rowIndex, int columnIndex) {
        Rectangle rec = this.reader.getPageSizeWithRotation(rowIndex + 1);
        switch (columnIndex) {
            case 0: {
                return this.myFormatter.format(rowIndex + 1);
            }
            case 1: {
                return new Float(rec.width());
            }
            case 2: {
                return new Float(rec.height());
            }
            case 3: {
                return new Float(rec.getRotation());
            }
        }
        return null;
    }

    public String getColumnName(int column) {
        String name = Integer.toString(column + 1);
        switch (column) {
            case 0: {
                name = "<html>Pagenr<p>" + name + "</html>";
                break;
            }
            case 1: {
                name = "<html>Width<p>" + name + "</html>";
                break;
            }
            case 2: {
                name = "<html>Height<p>" + name + "</html>";
                break;
            }
            case 3: {
                name = "<html>Rotation<p>" + name + "</html>";
                break;
            }
            default: {
                name = "<html>-<p>" + name + "</html>";
            }
        }
        return name;
    }
}

