/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.html.simpleparser;

import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;

public class IncTable {
    private HashMap props = new HashMap();
    private ArrayList rows = new ArrayList();
    private ArrayList cols;

    public IncTable(HashMap props) {
        this.props.putAll(props);
    }

    public void addCol(PdfPCell cell) {
        if (this.cols == null) {
            this.cols = new ArrayList();
        }
        this.cols.add(cell);
    }

    public void addCols(ArrayList ncols) {
        if (this.cols == null) {
            this.cols = new ArrayList(ncols);
        } else {
            this.cols.addAll(ncols);
        }
    }

    public void endRow() {
        if (this.cols != null) {
            Collections.reverse(this.cols);
            this.rows.add(this.cols);
            this.cols = null;
        }
    }

    public ArrayList getRows() {
        return this.rows;
    }

    public PdfPTable buildTable() {
        if (this.rows.isEmpty()) {
            return new PdfPTable(1);
        }
        int ncol = 0;
        ArrayList c0 = (ArrayList)this.rows.get(0);
        int k = 0;
        while (k < c0.size()) {
            ncol += ((PdfPCell)c0.get(k)).getColspan();
            ++k;
        }
        PdfPTable table = new PdfPTable(ncol);
        String width = (String)this.props.get("width");
        if (width == null) {
            table.setWidthPercentage(100.0f);
        } else if (width.endsWith("%")) {
            table.setWidthPercentage(Float.parseFloat(width.substring(0, width.length() - 1)));
        } else {
            table.setTotalWidth(Float.parseFloat(width));
            table.setLockedWidth(true);
        }
        int row = 0;
        while (row < this.rows.size()) {
            ArrayList col = (ArrayList)this.rows.get(row);
            int k2 = 0;
            while (k2 < col.size()) {
                table.addCell((PdfPCell)col.get(k2));
                ++k2;
            }
            ++row;
        }
        return table;
    }
}

