/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ConnectedEndPoint;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.nio.IndirectNIOBuffer;
import org.eclipse.jetty.io.nio.SelectChannelEndPoint;
import org.eclipse.jetty.io.nio.SelectorManager;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConnection;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.HostMap;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.ThreadPool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectHandler
extends HandlerWrapper {
    private static final Logger LOG = Log.getLogger(ConnectHandler.class);
    private final Logger _logger = Log.getLogger((String)this.getClass().getName());
    private final SelectorManager _selectorManager = new Manager();
    private volatile int _connectTimeout = 5000;
    private volatile int _writeTimeout = 30000;
    private volatile ThreadPool _threadPool;
    private volatile boolean _privateThreadPool;
    private HostMap<String> _white = new HostMap();
    private HostMap<String> _black = new HostMap();

    public ConnectHandler() {
        this(null);
    }

    public ConnectHandler(String[] white, String[] black) {
        this(null, white, black);
    }

    public ConnectHandler(Handler handler) {
        this.setHandler(handler);
    }

    public ConnectHandler(Handler handler, String[] white, String[] black) {
        this.setHandler(handler);
        this.set(white, this._white);
        this.set(black, this._black);
    }

    public int getConnectTimeout() {
        return this._connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this._connectTimeout = connectTimeout;
    }

    public int getWriteTimeout() {
        return this._writeTimeout;
    }

    public void setWriteTimeout(int writeTimeout) {
        this._writeTimeout = writeTimeout;
    }

    @Override
    public void setServer(Server server) {
        super.setServer(server);
        server.getContainer().update((Object)this, null, (Object)this._selectorManager, "selectManager");
        if (this._privateThreadPool) {
            server.getContainer().update((Object)this, null, (Object)this._privateThreadPool, "threadpool", true);
        } else {
            this._threadPool = server.getThreadPool();
        }
    }

    public ThreadPool getThreadPool() {
        return this._threadPool;
    }

    public void setThreadPool(ThreadPool threadPool) {
        if (this.getServer() != null) {
            this.getServer().getContainer().update((Object)this, (Object)(this._privateThreadPool ? this._threadPool : null), (Object)threadPool, "threadpool", true);
        }
        this._privateThreadPool = threadPool != null;
        this._threadPool = threadPool;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        if (this._threadPool == null) {
            this._threadPool = this.getServer().getThreadPool();
            this._privateThreadPool = false;
        }
        if (this._threadPool instanceof LifeCycle && !((LifeCycle)this._threadPool).isRunning()) {
            ((LifeCycle)this._threadPool).start();
        }
        this._selectorManager.start();
    }

    @Override
    protected void doStop() throws Exception {
        this._selectorManager.stop();
        ThreadPool threadPool = this._threadPool;
        if (this._privateThreadPool && this._threadPool != null && threadPool instanceof LifeCycle) {
            ((LifeCycle)threadPool).stop();
        }
        super.doStop();
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if ("CONNECT".equalsIgnoreCase(request.getMethod())) {
            this._logger.debug("CONNECT request for {}", new Object[]{request.getRequestURI()});
            try {
                this.handleConnect(baseRequest, request, response, request.getRequestURI());
            }
            catch (Exception e) {
                this._logger.warn("ConnectHandler " + baseRequest.getUri() + " " + e, new Object[0]);
                this._logger.debug((Throwable)e);
            }
        } else {
            super.handle(target, baseRequest, request, response);
        }
    }

    protected void handleConnect(Request baseRequest, HttpServletRequest request, HttpServletResponse response, String serverAddress) throws ServletException, IOException {
        boolean proceed = this.handleAuthentication(request, response, serverAddress);
        if (!proceed) {
            return;
        }
        String host = serverAddress;
        int port = 80;
        int colon = serverAddress.indexOf(58);
        if (colon > 0) {
            host = serverAddress.substring(0, colon);
            port = Integer.parseInt(serverAddress.substring(colon + 1));
        }
        if (!this.validateDestination(host)) {
            LOG.info("ProxyHandler: Forbidden destination " + host, new Object[0]);
            response.setStatus(403);
            baseRequest.setHandled(true);
            return;
        }
        SocketChannel channel = this.connectToServer(request, host, port);
        HttpConnection httpConnection = HttpConnection.getCurrentConnection();
        Buffer headerBuffer = ((HttpParser)httpConnection.getParser()).getHeaderBuffer();
        Buffer bodyBuffer = ((HttpParser)httpConnection.getParser()).getBodyBuffer();
        int length = headerBuffer == null ? 0 : headerBuffer.length();
        int n = bodyBuffer == null ? 0 : bodyBuffer.length();
        IndirectNIOBuffer buffer = null;
        if ((length += n) > 0) {
            buffer = new IndirectNIOBuffer(length);
            if (headerBuffer != null) {
                buffer.put(headerBuffer);
                headerBuffer.clear();
            }
            if (bodyBuffer != null) {
                buffer.put(bodyBuffer);
                bodyBuffer.clear();
            }
        }
        ConcurrentHashMap<String, Object> context = new ConcurrentHashMap<String, Object>();
        this.prepareContext(request, context);
        ClientToProxyConnection clientToProxy = this.prepareConnections(context, channel, (Buffer)buffer);
        response.setStatus(200);
        baseRequest.getConnection().getGenerator().setPersistent(true);
        response.getOutputStream().close();
        this.upgradeConnection(request, response, clientToProxy);
    }

    private ClientToProxyConnection prepareConnections(ConcurrentMap<String, Object> context, SocketChannel channel, Buffer buffer) {
        HttpConnection httpConnection = HttpConnection.getCurrentConnection();
        ProxyToServerConnection proxyToServer = this.newProxyToServerConnection(context, buffer);
        ClientToProxyConnection clientToProxy = this.newClientToProxyConnection(context, channel, httpConnection.getEndPoint(), httpConnection.getTimeStamp());
        clientToProxy.setConnection(proxyToServer);
        proxyToServer.setConnection(clientToProxy);
        return clientToProxy;
    }

    protected boolean handleAuthentication(HttpServletRequest request, HttpServletResponse response, String address) throws ServletException, IOException {
        return true;
    }

    protected ClientToProxyConnection newClientToProxyConnection(ConcurrentMap<String, Object> context, SocketChannel channel, EndPoint endPoint, long timeStamp) {
        return new ClientToProxyConnection(context, channel, endPoint, timeStamp);
    }

    protected ProxyToServerConnection newProxyToServerConnection(ConcurrentMap<String, Object> context, Buffer buffer) {
        return new ProxyToServerConnection(context, buffer);
    }

    private SocketChannel connectToServer(HttpServletRequest request, String host, int port) throws IOException {
        SocketChannel channel = this.connect(request, host, port);
        channel.configureBlocking(false);
        return channel;
    }

    protected SocketChannel connect(HttpServletRequest request, String host, int port) throws IOException {
        SocketChannel channel = SocketChannel.open();
        try {
            this._logger.debug("Establishing connection to {}:{}", new Object[]{host, port});
            channel.socket().setTcpNoDelay(true);
            channel.socket().connect(new InetSocketAddress(host, port), this.getConnectTimeout());
            this._logger.debug("Established connection to {}:{}", new Object[]{host, port});
            return channel;
        }
        catch (IOException x) {
            this._logger.debug("Failed to establish connection to " + host + ":" + port, (Throwable)x);
            try {
                channel.close();
            }
            catch (IOException xx) {
                LOG.ignore((Throwable)xx);
            }
            throw x;
        }
    }

    protected void prepareContext(HttpServletRequest request, ConcurrentMap<String, Object> context) {
    }

    private void upgradeConnection(HttpServletRequest request, HttpServletResponse response, Connection connection) throws IOException {
        request.setAttribute("org.eclipse.jetty.io.Connection", (Object)connection);
        response.setStatus(101);
        this._logger.debug("Upgraded connection to {}", new Object[]{connection});
    }

    private void register(SocketChannel channel, ProxyToServerConnection proxyToServer) throws IOException {
        this._selectorManager.register(channel, (Object)proxyToServer);
        proxyToServer.waitReady(this._connectTimeout);
    }

    protected int read(EndPoint endPoint, Buffer buffer, ConcurrentMap<String, Object> context) throws IOException {
        return endPoint.fill(buffer);
    }

    protected int write(EndPoint endPoint, Buffer buffer, ConcurrentMap<String, Object> context) throws IOException {
        if (buffer == null) {
            return 0;
        }
        int length = buffer.length();
        StringBuilder builder = new StringBuilder();
        int written = endPoint.flush(buffer);
        builder.append(written);
        buffer.compact();
        if (!endPoint.isBlocking()) {
            while (buffer.space() == 0) {
                boolean ready = endPoint.blockWritable((long)this.getWriteTimeout());
                if (!ready) {
                    throw new IOException("Write timeout");
                }
                written = endPoint.flush(buffer);
                builder.append("+").append(written);
                buffer.compact();
            }
        }
        this._logger.debug("Written {}/{} bytes {}", new Object[]{builder, length, endPoint});
        return length;
    }

    public void addWhite(String entry) {
        this.add(entry, this._white);
    }

    public void addBlack(String entry) {
        this.add(entry, this._black);
    }

    public void setWhite(String[] entries) {
        this.set(entries, this._white);
    }

    public void setBlack(String[] entries) {
        this.set(entries, this._black);
    }

    protected void set(String[] entries, HostMap<String> hostMap) {
        hostMap.clear();
        if (entries != null && entries.length > 0) {
            for (String addrPath : entries) {
                this.add(addrPath, hostMap);
            }
        }
    }

    private void add(String entry, HostMap<String> hostMap) {
        if (entry != null && entry.length() > 0 && hostMap.get((Object)(entry = entry.trim())) == null) {
            hostMap.put(entry, (Object)entry);
        }
    }

    public boolean validateDestination(String host) {
        Object blackObj;
        Object whiteObj;
        if (this._white.size() > 0 && (whiteObj = this._white.getLazyMatches(host)) == null) {
            return false;
        }
        return this._black.size() <= 0 || (blackObj = this._black.getLazyMatches(host)) == null;
    }

    @Override
    public void dump(Appendable out, String indent) throws IOException {
        this.dumpThis(out);
        if (this._privateThreadPool) {
            ConnectHandler.dump((Appendable)out, (String)indent, (Collection[])new Collection[]{Arrays.asList(this._threadPool, this._selectorManager), TypeUtil.asList((Object[])this.getHandlers()), this.getBeans()});
        } else {
            ConnectHandler.dump((Appendable)out, (String)indent, (Collection[])new Collection[]{Arrays.asList(this._selectorManager), TypeUtil.asList((Object[])this.getHandlers()), this.getBeans()});
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ClientToProxyConnection
    implements Connection {
        private final Buffer _buffer = new IndirectNIOBuffer(1024);
        private final ConcurrentMap<String, Object> _context;
        private final SocketChannel _channel;
        private final EndPoint _endPoint;
        private final long _timestamp;
        private volatile ProxyToServerConnection _toServer;
        private boolean _firstTime = true;

        public ClientToProxyConnection(ConcurrentMap<String, Object> context, SocketChannel channel, EndPoint endPoint, long timestamp) {
            this._context = context;
            this._channel = channel;
            this._endPoint = endPoint;
            this._timestamp = timestamp;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("ClientToProxy");
            builder.append("(:").append(this._endPoint.getLocalPort());
            builder.append("<=>:").append(this._endPoint.getRemotePort());
            return builder.append(")").toString();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Connection handle() throws IOException {
            ClientToProxyConnection read2;
            ConnectHandler.this._logger.debug("{}: begin reading from client", new Object[]{this});
            try {
                try {
                    if (this._firstTime) {
                        this._firstTime = false;
                        ConnectHandler.this.register(this._channel, this._toServer);
                        ConnectHandler.this._logger.debug("{}: registered channel {} with connection {}", new Object[]{this, this._channel, this._toServer});
                    }
                    while (true) {
                        int read2;
                        if ((read2 = ConnectHandler.this.read(this._endPoint, this._buffer, this._context)) == -1) {
                            ConnectHandler.this._logger.debug("{}: client closed connection {}", new Object[]{this, this._endPoint});
                            if (this._endPoint.isOutputShutdown() || !this._endPoint.isOpen()) {
                                this.closeServer();
                                break;
                            }
                            this._toServer.shutdownOutput();
                            break;
                        }
                        if (read2 == 0) break;
                        ConnectHandler.this._logger.debug("{}: read from client {} bytes {}", new Object[]{this, read2, this._endPoint});
                        int written = ConnectHandler.this.write((EndPoint)this._toServer._endPoint, this._buffer, this._context);
                        ConnectHandler.this._logger.debug("{}: written to {} {} bytes", new Object[]{this, this._toServer, written});
                    }
                    read2 = this;
                    Object var4_7 = null;
                }
                catch (ClosedChannelException x) {
                    ConnectHandler.this._logger.debug((Throwable)x);
                    this.closeServer();
                    throw x;
                }
                catch (IOException x) {
                    ConnectHandler.this._logger.warn(this + ": unexpected exception", (Throwable)x);
                    this.close();
                    throw x;
                }
                catch (RuntimeException x) {
                    ConnectHandler.this._logger.warn(this + ": unexpected exception", (Throwable)x);
                    this.close();
                    throw x;
                }
            }
            catch (Throwable throwable) {
                Object var4_8 = null;
                ConnectHandler.this._logger.debug("{}: end reading from client", new Object[]{this});
                throw throwable;
            }
            ConnectHandler.this._logger.debug("{}: end reading from client", new Object[]{this});
            return read2;
        }

        public long getTimeStamp() {
            return this._timestamp;
        }

        public boolean isIdle() {
            return false;
        }

        public boolean isSuspended() {
            return false;
        }

        public void closed() {
        }

        public void setConnection(ProxyToServerConnection connection) {
            this._toServer = connection;
        }

        public void closeClient() throws IOException {
            this._endPoint.close();
        }

        public void closeServer() throws IOException {
            this._toServer.closeServer();
        }

        public void close() {
            try {
                this.closeClient();
            }
            catch (IOException x) {
                ConnectHandler.this._logger.debug(this + ": unexpected exception closing the client", (Throwable)x);
            }
            try {
                this.closeServer();
            }
            catch (IOException x) {
                ConnectHandler.this._logger.debug(this + ": unexpected exception closing the server", (Throwable)x);
            }
        }

        public void shutdownOutput() throws IOException {
            this._endPoint.shutdownOutput();
        }

        public void idleExpired() {
            try {
                this.shutdownOutput();
            }
            catch (Exception e) {
                LOG.debug((Throwable)e);
                this.close();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class ProxyToServerConnection
    implements Connection {
        private final CountDownLatch _ready = new CountDownLatch(1);
        private final Buffer _buffer = new IndirectNIOBuffer(1024);
        private final ConcurrentMap<String, Object> _context;
        private volatile Buffer _data;
        private volatile ClientToProxyConnection _toClient;
        private volatile long _timestamp;
        private volatile SelectChannelEndPoint _endPoint;

        public ProxyToServerConnection(ConcurrentMap<String, Object> context, Buffer data) {
            this._context = context;
            this._data = data;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("ProxyToServer");
            builder.append("(:").append(this._endPoint.getLocalPort());
            builder.append("<=>:").append(this._endPoint.getRemotePort());
            return builder.append(")").toString();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Connection handle() throws IOException {
            ProxyToServerConnection read2;
            ConnectHandler.this._logger.debug("{}: begin reading from server", new Object[]{this});
            try {
                try {
                    this.writeData();
                    while (true) {
                        int read2;
                        if ((read2 = ConnectHandler.this.read((EndPoint)this._endPoint, this._buffer, this._context)) == -1) {
                            ConnectHandler.this._logger.debug("{}: server closed connection {}", new Object[]{this, this._endPoint});
                            if (this._endPoint.isOutputShutdown() || !this._endPoint.isOpen()) {
                                this.closeClient();
                                break;
                            }
                            this._toClient.shutdownOutput();
                            break;
                        }
                        if (read2 == 0) break;
                        ConnectHandler.this._logger.debug("{}: read from server {} bytes {}", new Object[]{this, read2, this._endPoint});
                        int written = ConnectHandler.this.write(this._toClient._endPoint, this._buffer, this._context);
                        ConnectHandler.this._logger.debug("{}: written to {} {} bytes", new Object[]{this, this._toClient, written});
                    }
                    read2 = this;
                    Object var4_7 = null;
                }
                catch (ClosedChannelException x) {
                    ConnectHandler.this._logger.debug((Throwable)x);
                    throw x;
                }
                catch (IOException x) {
                    ConnectHandler.this._logger.warn(this + ": unexpected exception", (Throwable)x);
                    this.close();
                    throw x;
                }
                catch (RuntimeException x) {
                    ConnectHandler.this._logger.warn(this + ": unexpected exception", (Throwable)x);
                    this.close();
                    throw x;
                }
            }
            catch (Throwable throwable) {
                Object var4_8 = null;
                ConnectHandler.this._logger.debug("{}: end reading from server", new Object[]{this});
                throw throwable;
            }
            ConnectHandler.this._logger.debug("{}: end reading from server", new Object[]{this});
            return read2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeData() throws IOException {
            ProxyToServerConnection proxyToServerConnection = this;
            synchronized (proxyToServerConnection) {
                if (this._data != null) {
                    try {
                        int written = ConnectHandler.this.write((EndPoint)this._endPoint, this._data, this._context);
                        ConnectHandler.this._logger.debug("{}: written to server {} bytes", new Object[]{this, written});
                        Object var4_3 = null;
                        this._data = null;
                    }
                    catch (Throwable throwable) {
                        Object var4_4 = null;
                        this._data = null;
                        throw throwable;
                    }
                }
            }
        }

        public void setConnection(ClientToProxyConnection connection) {
            this._toClient = connection;
        }

        public long getTimeStamp() {
            return this._timestamp;
        }

        public void setTimeStamp(long timestamp) {
            this._timestamp = timestamp;
        }

        public void setEndPoint(SelectChannelEndPoint endpoint) {
            this._endPoint = endpoint;
        }

        public boolean isIdle() {
            return false;
        }

        public boolean isSuspended() {
            return false;
        }

        public void closed() {
        }

        public void ready() {
            this._ready.countDown();
        }

        public void waitReady(long timeout) throws IOException {
            try {
                this._ready.await(timeout, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException x) {
                throw new IOException(){
                    {
                        this.initCause(x);
                    }
                };
            }
        }

        public void closeClient() throws IOException {
            this._toClient.closeClient();
        }

        public void closeServer() throws IOException {
            this._endPoint.close();
        }

        public void close() {
            try {
                this.closeClient();
            }
            catch (IOException x) {
                ConnectHandler.this._logger.debug(this + ": unexpected exception closing the client", (Throwable)x);
            }
            try {
                this.closeServer();
            }
            catch (IOException x) {
                ConnectHandler.this._logger.debug(this + ": unexpected exception closing the server", (Throwable)x);
            }
        }

        public void shutdownOutput() throws IOException {
            this.writeData();
            this._endPoint.shutdownOutput();
        }

        public void idleExpired() {
            try {
                this.shutdownOutput();
            }
            catch (Exception e) {
                LOG.debug((Throwable)e);
                this.close();
            }
        }
    }

    private class Manager
    extends SelectorManager {
        private Manager() {
        }

        protected SelectChannelEndPoint newEndPoint(SocketChannel channel, SelectorManager.SelectSet selectSet, SelectionKey selectionKey) throws IOException {
            SelectChannelEndPoint endp = new SelectChannelEndPoint(channel, selectSet, selectionKey);
            endp.setMaxIdleTime(ConnectHandler.this._writeTimeout);
            return endp;
        }

        protected Connection newConnection(SocketChannel channel, SelectChannelEndPoint endpoint) {
            ProxyToServerConnection proxyToServer = (ProxyToServerConnection)endpoint.getSelectionKey().attachment();
            proxyToServer.setTimeStamp(System.currentTimeMillis());
            proxyToServer.setEndPoint(endpoint);
            return proxyToServer;
        }

        protected void endPointOpened(SelectChannelEndPoint endpoint) {
            ProxyToServerConnection proxyToServer = (ProxyToServerConnection)endpoint.getSelectionKey().attachment();
            proxyToServer.ready();
        }

        public boolean dispatch(Runnable task) {
            return ConnectHandler.this._threadPool.dispatch(task);
        }

        protected void endPointClosed(SelectChannelEndPoint endpoint) {
        }

        protected void endPointUpgraded(ConnectedEndPoint endpoint, Connection oldConnection) {
        }
    }
}

