/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jml.message.p2p;

import java.nio.ByteBuffer;
import net.sf.jml.MsnContact;
import net.sf.jml.MsnObject;
import net.sf.jml.message.p2p.DisplayPictureDuelManager;
import net.sf.jml.message.p2p.DisplayPictureDuelTimer;
import net.sf.jml.message.p2p.DisplayPictureDuelTimerTask;
import net.sf.jml.message.p2p.MsnP2PAckMessage;
import net.sf.jml.message.p2p.MsnP2PBaseIdGenerator;
import net.sf.jml.message.p2p.MsnP2PDataMessage;
import net.sf.jml.message.p2p.MsnP2PMessage;
import net.sf.jml.message.p2p.MsnP2PPreperationMessage;
import net.sf.jml.message.p2p.MsnP2PSlpMessage;
import net.sf.jml.protocol.MsnSession;
import net.sf.jml.protocol.msnslp.MsnslpMessage;
import net.sf.jml.protocol.msnslp.MsnslpResponse;
import net.sf.jml.protocol.outgoing.OutgoingMSG;
import net.sf.jml.util.Charset;
import net.sf.jml.util.NumberUtils;
import net.sf.jml.util.StringHolder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DisplayPictureDuel {
    protected final transient Log log = LogFactory.getLog(this.getClass());
    private MsnSession session;
    private int timerStatus;
    private int step;
    private int baseId;
    private int sessionId;
    private ByteBuffer displayPicture;
    private int offset;

    public int getBaseId() {
        return this.baseId;
    }

    private int nextBaseId() {
        this.baseId = MsnP2PBaseIdGenerator.getInstance().getNextId();
        return this.baseId;
    }

    public DisplayPictureDuel(MsnSession msnSession, MsnObject msnObject) {
        this.session = msnSession;
        this.timerStatus = 0;
        this.step = 0;
        if (msnObject != null && msnObject.getMsnObj() != null) {
            this.displayPicture = ByteBuffer.wrap(msnObject.getMsnObj());
            this.displayPicture.clear();
        }
    }

    public MsnSession getSession() {
        return this.session;
    }

    public void processError() {
        DisplayPictureDuelManager.getDuelManager().remove(this.getBaseId());
        this.log.warn((Object)("display picture duel process error,in step:" + this.step));
    }

    public void process(MsnP2PMessage msnP2PMessage, MsnContact msnContact) {
        switch (this.step) {
            case 1: {
                if (msnP2PMessage.getFlag() != 2) {
                    this.processError();
                    return;
                }
                if (msnP2PMessage.getField7() != this.getBaseId()) {
                    this.processError();
                    return;
                }
                MsnP2PPreperationMessage msnP2PPreperationMessage = new MsnP2PPreperationMessage(this.sessionId, this.nextBaseId(), msnContact.getEmail().getEmailAddress());
                OutgoingMSG[] outgoingMSGArray = msnP2PPreperationMessage.toOutgoingMsg(this.session.getMessenger().getActualMsnProtocol());
                for (int i = 0; i < outgoingMSGArray.length; ++i) {
                    this.session.sendSynchronousMessage(outgoingMSGArray[i]);
                }
                this.step = 2;
                break;
            }
            case 2: {
                if (msnP2PMessage.getFlag() != 2) {
                    this.processError();
                    return;
                }
                if (msnP2PMessage.getField7() != this.getBaseId()) {
                    this.processError();
                    return;
                }
                if (msnP2PMessage.getSessionId() != this.sessionId) {
                    this.processError();
                    return;
                }
                int n = this.nextBaseId();
                while (this.displayPicture != null && this.displayPicture.hasRemaining()) {
                    this.offset = this.displayPicture.position();
                    int n2 = this.displayPicture.remaining() > 1202 ? 1202 : this.displayPicture.remaining();
                    byte[] byArray = new byte[n2];
                    this.displayPicture.get(byArray);
                    MsnP2PDataMessage msnP2PDataMessage = new MsnP2PDataMessage(this.sessionId, n, this.offset, this.displayPicture.capacity(), byArray, msnContact.getEmail().getEmailAddress());
                    OutgoingMSG[] outgoingMSGArray = msnP2PDataMessage.toOutgoingMsg(this.session.getMessenger().getActualMsnProtocol());
                    for (int i = 0; i < outgoingMSGArray.length; ++i) {
                        this.session.sendSynchronousMessage(outgoingMSGArray[i]);
                    }
                }
                this.step = 3;
                break;
            }
            case 3: {
                if (msnP2PMessage.getFlag() != 2) {
                    this.processError();
                    return;
                }
                if (msnP2PMessage.getField7() != this.getBaseId()) {
                    this.processError();
                    return;
                }
                if (msnP2PMessage.getSessionId() != this.sessionId) {
                    this.processError();
                    return;
                }
                DisplayPictureDuelManager.getDuelManager().remove(this.getBaseId());
                this.step = 4;
                return;
            }
        }
        this.startDuelTimer();
    }

    public void start(MsnP2PSlpMessage msnP2PSlpMessage, MsnContact msnContact) {
        MsnP2PAckMessage msnP2PAckMessage = new MsnP2PAckMessage(this.nextBaseId(), msnContact.getEmail().getEmailAddress(), msnP2PSlpMessage);
        OutgoingMSG[] outgoingMSGArray = msnP2PAckMessage.toOutgoingMsg(this.session.getMessenger().getActualMsnProtocol());
        for (int i = 0; i < outgoingMSGArray.length; ++i) {
            this.session.sendSynchronousMessage(outgoingMSGArray[i]);
        }
        MsnslpMessage msnslpMessage = msnP2PSlpMessage.getSlpMessage();
        MsnslpResponse msnslpResponse = new MsnslpResponse();
        msnslpResponse.setTo(msnslpMessage.getFrom());
        msnslpResponse.setFrom(msnslpMessage.getTo());
        msnslpResponse.setVia(msnslpMessage.getVia());
        msnslpResponse.setCSeq(msnslpMessage.getCSeq() + 1);
        msnslpResponse.setCallId(msnslpMessage.getCallId());
        msnslpResponse.setMaxForwards(msnslpMessage.getMaxForwards());
        msnslpResponse.setContentType(msnslpMessage.getContentType());
        this.sessionId = msnslpMessage.getBodys().getIntProperty("SessionID", -1);
        StringHolder stringHolder = new StringHolder();
        stringHolder.setProperty("SessionID", this.sessionId);
        msnslpResponse.setBody(stringHolder.toString() + "\r\n" + "\u0000");
        int n = Charset.encodeAsByteArray(msnslpResponse.toString()).length;
        MsnP2PSlpMessage msnP2PSlpMessage2 = new MsnP2PSlpMessage();
        msnP2PSlpMessage2.setSlpMessage(msnslpResponse);
        msnP2PSlpMessage2.setIdentifier(this.nextBaseId());
        msnP2PSlpMessage2.setTotalLength(n);
        msnP2PSlpMessage2.setCurrentLength(n);
        msnP2PSlpMessage2.setField7(NumberUtils.getIntRandom());
        msnP2PSlpMessage2.setP2PDest(msnContact.getEmail().getEmailAddress());
        OutgoingMSG[] outgoingMSGArray2 = msnP2PSlpMessage2.toOutgoingMsg(this.session.getMessenger().getActualMsnProtocol());
        for (int i = 0; i < outgoingMSGArray2.length; ++i) {
            this.session.sendSynchronousMessage(outgoingMSGArray2[i]);
        }
        this.step = 1;
        this.startDuelTimer();
    }

    private void startDuelTimer() {
        ++this.timerStatus;
        DisplayPictureDuelTimer.getDuelTimer().schedule(new DisplayPictureDuelTimerTask(this.getBaseId(), this.timerStatus), 60000L);
    }

    public int getDuelTimerStatus() {
        return this.timerStatus;
    }
}

