/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.recordstore.ExpiredKey;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.BackupOperation;
import com.hazelcast.spi.ExceptionAction;
import com.hazelcast.spi.exception.WrongTargetException;
import com.hazelcast.util.CollectionUtil;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;

public class EvictBatchBackupOperation
extends MapOperation
implements BackupOperation {
    private String name;
    private Collection<ExpiredKey> expiredKeys;
    private int ownerPartitionEntryCount;

    public EvictBatchBackupOperation() {
    }

    public EvictBatchBackupOperation(String name, Collection<ExpiredKey> expiredKeys, int ownerPartitionEntryCount) {
        super(name);
        assert (CollectionUtil.isNotEmpty(expiredKeys));
        assert (name != null);
        this.name = name;
        this.expiredKeys = expiredKeys;
        this.ownerPartitionEntryCount = ownerPartitionEntryCount;
    }

    @Override
    public void run() {
        assert (this.getNodeEngine().getClusterService().getClusterVersion().isGreaterOrEqual(Versions.V3_9));
        for (ExpiredKey expiredKey : this.expiredKeys) {
            Object existingRecord = this.recordStore.getRecord(expiredKey.getKey());
            if (!this.canEvictRecord((Record)existingRecord, expiredKey)) continue;
            this.recordStore.evict(existingRecord.getKey(), true);
        }
        int diff = this.recordStore.size() - this.ownerPartitionEntryCount;
        for (int i = 0; i < diff; ++i) {
            this.mapContainer.getEvictor().evict(this.recordStore, null);
        }
    }

    @Override
    public ExceptionAction onInvocationException(Throwable throwable) {
        if (throwable instanceof WrongTargetException && ((WrongTargetException)throwable).getTarget() == null) {
            return ExceptionAction.THROW_EXCEPTION;
        }
        return super.onInvocationException(throwable);
    }

    protected boolean canEvictRecord(Record existingRecord, ExpiredKey expiredKey) {
        if (existingRecord == null) {
            return false;
        }
        return existingRecord.getCreationTime() == expiredKey.getCreationTime();
    }

    @Override
    public int getId() {
        return 140;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeUTF(this.name);
        out.writeInt(this.expiredKeys.size());
        for (ExpiredKey expiredKey : this.expiredKeys) {
            out.writeData(expiredKey.getKey());
            out.writeLong(expiredKey.getCreationTime());
        }
        out.writeInt(this.ownerPartitionEntryCount);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.name = in.readUTF();
        int size = in.readInt();
        this.expiredKeys = new LinkedList<ExpiredKey>();
        for (int i = 0; i < size; ++i) {
            this.expiredKeys.add(new ExpiredKey(in.readData(), in.readLong()));
        }
        this.ownerPartitionEntryCount = in.readInt();
    }
}

