/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.internal.cluster.Versions;
import com.hazelcast.internal.partition.InternalPartitionService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.operation.SynchronizeIndexesForPartitionTask;
import com.hazelcast.query.impl.IndexInfo;
import com.hazelcast.query.impl.MapIndexInfo;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.OperationService;
import com.hazelcast.spi.impl.operationservice.impl.OperationServiceImpl;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.version.Version;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

class MapIndexSynchronizer {
    protected MapServiceContext mapServiceContext;
    protected OperationService operationService;
    protected SerializationService serializationService;
    protected NodeEngine nodeEngine;
    private ILogger logger;
    private Version currentVersion;

    public MapIndexSynchronizer(MapServiceContext mapServiceContext, NodeEngine nodeEngine) {
        this.mapServiceContext = mapServiceContext;
        this.operationService = nodeEngine.getOperationService();
        this.serializationService = nodeEngine.getSerializationService();
        this.nodeEngine = nodeEngine;
        this.logger = nodeEngine.getLogger(this.getClass());
    }

    public void onClusterVersionChange(Version newVersion) {
        if (this.isV38toV39transition(newVersion)) {
            this.synchronizeIndexes();
        }
        this.currentVersion = newVersion;
    }

    private void synchronizeIndexes() {
        this.logger.info("Running MapIndexSynchronizer");
        List<MapIndexInfo> mapIndexInfos = this.getIndexesToSynchronize();
        if (!mapIndexInfos.isEmpty()) {
            this.executeIndexSync(mapIndexInfos);
        }
    }

    private List<MapIndexInfo> getIndexesToSynchronize() {
        ArrayList<MapIndexInfo> mapIndexInfos = new ArrayList<MapIndexInfo>();
        for (Map.Entry<String, MapContainer> entry : this.mapServiceContext.getMapContainers().entrySet()) {
            MapContainer mapContainer = entry.getValue();
            int indexesToSynchronize = mapContainer.getPartitionIndexesToAdd().size();
            if (indexesToSynchronize > 0) {
                String mapName = entry.getKey();
                this.logger.info("Scheduling " + indexesToSynchronize + " indexes sync for map " + mapName);
                MapIndexInfo mapIndexInfo = new MapIndexInfo(mapName);
                for (IndexInfo indexInfo : mapContainer.getPartitionIndexesToAdd()) {
                    mapIndexInfo.addIndexInfo(indexInfo.getAttributeName(), indexInfo.isOrdered());
                }
                mapIndexInfos.add(mapIndexInfo);
            }
            mapContainer.clearPartitionIndexesToAdd();
        }
        return mapIndexInfos;
    }

    private void executeIndexSync(List<MapIndexInfo> mapIndexInfos) {
        OperationServiceImpl operationServiceImpl = (OperationServiceImpl)this.operationService;
        for (int partitionId : this.mapServiceContext.getOwnedPartitions()) {
            SynchronizeIndexesForPartitionTask task = new SynchronizeIndexesForPartitionTask(partitionId, mapIndexInfos, this.mapServiceContext.getService(), this.serializationService, (InternalPartitionService)this.nodeEngine.getPartitionService());
            operationServiceImpl.execute(task);
        }
    }

    private boolean isV38toV39transition(Version newVersion) {
        return this.currentVersion != null && this.currentVersion.equals(Versions.V3_8) && newVersion.equals(Versions.V3_9);
    }
}

