/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cardinality.impl;

import com.hazelcast.cardinality.impl.CardinalityEstimatorDataSerializerHook;
import com.hazelcast.cardinality.impl.hyperloglog.HyperLogLog;
import com.hazelcast.cardinality.impl.hyperloglog.impl.HyperLogLogImpl;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;

public class CardinalityEstimatorContainer
implements IdentifiedDataSerializable {
    private int backupCount;
    private int asyncBackupCount;
    private HyperLogLog hll = new HyperLogLogImpl();

    public CardinalityEstimatorContainer() {
        this(1, 0);
    }

    public CardinalityEstimatorContainer(int backupCount, int asyncBackupCount) {
        this.backupCount = backupCount;
        this.asyncBackupCount = asyncBackupCount;
    }

    public void add(long hash) {
        this.hll.add(hash);
    }

    public long estimate() {
        return this.hll.estimate();
    }

    public int getBackupCount() {
        return this.backupCount;
    }

    public int getAsyncBackupCount() {
        return this.asyncBackupCount;
    }

    public int getTotalBackupCount() {
        return this.backupCount + this.asyncBackupCount;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.hll);
        out.writeInt(this.backupCount);
        out.writeInt(this.asyncBackupCount);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.hll = (HyperLogLog)in.readObject();
        this.backupCount = in.readInt();
        this.asyncBackupCount = in.readInt();
    }

    @Override
    public int getFactoryId() {
        return CardinalityEstimatorDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 4;
    }
}

