/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jqql.net;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.Queue;
import net.sf.jqql.net.IConnectionPolicy;
import net.sf.jqql.net.IConnectionPool;
import net.sf.jqql.net.INIOHandler;
import net.sf.jqql.net.IPort;
import net.sf.jqql.packets.ErrorPacket;
import net.sf.jqql.packets._08OutPacket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

abstract class AbstractPort
implements IPort,
INIOHandler {
    private static final Log log = LogFactory.getLog(AbstractPort.class);
    protected ByteBuffer sendBuf;
    protected ByteBuffer receiveBuf;
    protected Queue<_08OutPacket> sendQueue;
    protected IConnectionPolicy policy;
    protected IConnectionPool pool;
    protected String name;
    protected InetSocketAddress remoteAddress;

    public AbstractPort(IConnectionPolicy iConnectionPolicy) {
        this.policy = iConnectionPolicy;
        this.sendQueue = new LinkedList<_08OutPacket>();
        this.sendBuf = ByteBuffer.allocateDirect(65535);
        this.receiveBuf = ByteBuffer.allocateDirect(65535);
    }

    public String getId() {
        return this.policy.getConnectionId();
    }

    public synchronized void clearSendQueue() {
        this.sendQueue.clear();
    }

    public IConnectionPool getPool() {
        return this.pool;
    }

    public void setPool(IConnectionPool iConnectionPool) {
        this.pool = iConnectionPool;
    }

    public synchronized void add(_08OutPacket _08OutPacket2) {
        this.sendQueue.offer(_08OutPacket2);
        this.policy.flush();
    }

    public synchronized boolean isEmpty() {
        return this.sendQueue.isEmpty();
    }

    public synchronized _08OutPacket remove() {
        return this.sendQueue.poll();
    }

    public INIOHandler getNIOHandler() {
        return this;
    }

    public void processError(Exception exception) {
        log.debug((Object)"\u7f51\u7edc\u51fa\u9519\uff0c\u5173\u95ed\u8fde\u63a5");
        this.getPool().release(this);
        ErrorPacket errorPacket = this.policy.createErrorPacket(3, this.getId());
        errorPacket.errorMessage = exception.getMessage();
        this.policy.pushIn(errorPacket);
    }

    public InetSocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public IConnectionPolicy getPolicy() {
        return this.policy;
    }
}

