/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.loc;

import java.util.List;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snac.CmdType;
import net.kano.joscar.snac.SnacCmdFactory;
import net.kano.joscar.snaccmd.loc.GetDirInfoCmd;
import net.kano.joscar.snaccmd.loc.GetInfoCmd;
import net.kano.joscar.snaccmd.loc.LocRightsRequest;
import net.kano.joscar.snaccmd.loc.OldGetInfoCmd;
import net.kano.joscar.snaccmd.loc.SetDirInfoCmd;
import net.kano.joscar.snaccmd.loc.SetInfoCmd;
import net.kano.joscar.snaccmd.loc.SetInterestsCmd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerLocCmdFactory
implements SnacCmdFactory {
    protected static final List<CmdType> SUPPORTED_TYPES = DefensiveTools.asUnmodifiableList((Object[])new CmdType[]{new CmdType(2, 2), new CmdType(2, 4), new CmdType(2, 5), new CmdType(2, 11), new CmdType(2, 15), new CmdType(2, 9), new CmdType(2, 21)});

    @Override
    public List<CmdType> getSupportedTypes() {
        return SUPPORTED_TYPES;
    }

    @Override
    public SnacCommand genSnacCommand(SnacPacket packet) {
        if (packet.getFamily() != 2) {
            return null;
        }
        int command = packet.getCommand();
        if (command == 2) {
            return new LocRightsRequest(packet);
        }
        if (command == 4) {
            return new SetInfoCmd(packet);
        }
        if (command == 5) {
            return new OldGetInfoCmd(packet);
        }
        if (command == 11) {
            return new GetDirInfoCmd(packet);
        }
        if (command == 15) {
            return new SetInterestsCmd(packet);
        }
        if (command == 9) {
            return new SetDirInfoCmd(packet);
        }
        if (command == 21) {
            return new GetInfoCmd(packet);
        }
        return null;
    }
}

