/*
 * Decompiled with CFR 0.152.
 */
package com.sun.medialib.codec.dtmf;

import com.sun.medialib.codec.dtmf.Constants;
import com.sun.medialib.codec.dtmf.DTMFException;
import com.sun.medialib.codec.dtmf.dtmf_tables;

final class DTMF_ENCODE
implements Constants {
    protected int std = 0;
    protected int rate = 8000;
    protected int amp = 5000;
    protected int ton = 100;
    protected int toff = 100;

    DTMF_ENCODE() {
    }

    public int getStd() {
        return this.std;
    }

    public int getRate() {
        return this.rate;
    }

    public int getAmp() {
        return this.amp;
    }

    public int getTon() {
        return this.ton;
    }

    public int getToff() {
        return this.toff;
    }

    public void setStd(int n) {
        if (n != 0 && n != 1 && n != 2 && n != 3 && n != 4) {
            throw new DTMFException(3);
        }
        this.std = n;
    }

    public void setRate(int n) {
        if (n < 0) {
            throw new DTMFException(6);
        }
        this.rate = n;
    }

    public void setAmp(int n) {
        if (n < 0 || n > Short.MAX_VALUE) {
            throw new DTMFException(8);
        }
        this.amp = n;
    }

    public void setTon(int n) {
        double[] dArray = dtmf_tables.dtmf_STD;
        for (int i = 0; i < 5; ++i) {
            if ((double)this.std != dArray[8 * i] || !((double)n < dArray[8 * i + 1])) continue;
            throw new DTMFException(5);
        }
        this.ton = n;
    }

    public void setToff(int n) {
        double[] dArray = dtmf_tables.dtmf_STD;
        for (int i = 0; i < 5; ++i) {
            if ((double)this.std != dArray[8 * i] || !((double)n < dArray[8 * i + 2])) continue;
            throw new DTMFException(4);
        }
        this.toff = n;
    }
}

