/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.util.scriptengine;

import javax.script.ScriptEngine;
import javax.script.ScriptException;

public class ScriptEvaluator {
    private final ScriptEngine engine;

    public ScriptEvaluator(ScriptEngine engine) {
        this.engine = engine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object evaluate(String script, Object obj, String objectAlias) throws ScriptException {
        if (this.engineAllowsParallelAccessFromMultipleThreads()) {
            return this.doEvaluate(script, obj, objectAlias);
        }
        ScriptEngine scriptEngine = this.engine;
        synchronized (scriptEngine) {
            return this.doEvaluate(script, obj, objectAlias);
        }
    }

    private Object doEvaluate(String script, Object obj, String objectAlias) throws ScriptException {
        this.engine.put(objectAlias, obj);
        return this.engine.eval(script);
    }

    private boolean engineAllowsParallelAccessFromMultipleThreads() {
        String threadingType = (String)this.engine.getFactory().getParameter("THREADING");
        return "THREAD-ISOLATED".equals(threadingType) || "STATELESS".equals(threadingType);
    }
}

