/*
 * Decompiled with CFR 0.152.
 */
package com.voxeo.web.assets;

import com.voxeo.web.assets.AbstractAsset;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import javax.servlet.ServletContext;
import org.apache.commons.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualAsset
extends AbstractAsset {
    String path;
    List<String> realPaths;
    private ServletContext servletContext;

    public VirtualAsset(ServletContext servletContext, String path, List<String> realPaths) {
        this.servletContext = servletContext;
        this.path = path;
        this.realPaths = realPaths;
    }

    @Override
    public boolean handles(String path) {
        return this.path.equals(path);
    }

    @Override
    public InputStream getInputStream(String path) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            for (String realPath : this.realPaths) {
                InputStream realStream = this.servletContext.getResourceAsStream(realPath);
                IOUtils.copy((InputStream)realStream, (OutputStream)baos);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        return new ByteArrayInputStream(baos.toByteArray());
    }

    @Override
    public boolean isReal() {
        return false;
    }
}

