/*
 * Decompiled with CFR 0.152.
 */
package net.java.sip.communicator.service.protocol.event;

import java.util.Date;
import java.util.EventObject;
import net.java.sip.communicator.service.protocol.ChatRoom;
import net.java.sip.communicator.service.protocol.Contact;
import net.java.sip.communicator.service.protocol.ContactResource;
import net.java.sip.communicator.service.protocol.Message;

public class MessageReceivedEvent
extends EventObject {
    private static final long serialVersionUID = 0L;
    public static final int CONVERSATION_MESSAGE_RECEIVED = 1;
    public static final int SYSTEM_MESSAGE_RECEIVED = 2;
    public static final int SMS_MESSAGE_RECEIVED = 3;
    private Contact from = null;
    private ContactResource fromResource = null;
    private final Date timestamp;
    private int eventType = -1;
    private String correctedMessageUID = null;
    private boolean isPrivateMessaging = false;
    private ChatRoom privateMessagingContactRoom = null;

    public MessageReceivedEvent(Message source, Contact from, Date timestamp) {
        this(source, from, timestamp, 1);
    }

    public MessageReceivedEvent(Message source, Contact from, String correctedMessageUID) {
        this(source, from, new Date(), 1);
        this.correctedMessageUID = correctedMessageUID;
    }

    public MessageReceivedEvent(Message source, Contact from, Date timestamp, String correctedMessageUID) {
        this(source, from, null, timestamp, correctedMessageUID);
    }

    public MessageReceivedEvent(Message source, Contact from, ContactResource fromResource, Date timestamp, String correctedMessageUID) {
        this(source, from, fromResource, timestamp, 1);
        this.correctedMessageUID = correctedMessageUID;
    }

    public MessageReceivedEvent(Message source, Contact from, ContactResource fromResource, Date timestamp, String correctedMessageUID, boolean isPrivateMessaging, ChatRoom privateContactRoom) {
        this(source, from, fromResource, timestamp, 1, isPrivateMessaging, privateContactRoom);
        this.correctedMessageUID = correctedMessageUID;
    }

    public MessageReceivedEvent(Message source, Contact from, Date timestamp, int eventType) {
        this(source, from, null, timestamp, eventType);
    }

    public MessageReceivedEvent(Message source, Contact from, ContactResource fromResource, Date timestamp, int eventType) {
        this(source, from, fromResource, timestamp, eventType, false, null);
    }

    public MessageReceivedEvent(Message source, Contact from, ContactResource fromResource, Date timestamp, int eventType, boolean isPrivateMessaging, ChatRoom privateContactRoom) {
        super(source);
        this.from = from;
        this.fromResource = fromResource;
        this.timestamp = timestamp;
        this.eventType = eventType;
        this.isPrivateMessaging = isPrivateMessaging;
        this.privateMessagingContactRoom = privateContactRoom;
    }

    public Contact getSourceContact() {
        return this.from;
    }

    public ContactResource getContactResource() {
        return this.fromResource;
    }

    public Message getSourceMessage() {
        return (Message)this.getSource();
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public int getEventType() {
        return this.eventType;
    }

    public String getCorrectedMessageUID() {
        return this.correctedMessageUID;
    }

    public ChatRoom getPrivateMessagingContactRoom() {
        return this.privateMessagingContactRoom;
    }

    public boolean isPrivateMessaging() {
        return this.isPrivateMessaging;
    }
}

