/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jqql.packets.in;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import net.sf.jqql.beans.FriendRemark;
import net.sf.jqql.beans.QQUser;
import net.sf.jqql.packets.PacketParseException;
import net.sf.jqql.packets._08BasicInPacket;

public class FriendDataOpReplyPacket
extends _08BasicInPacket {
    public byte replyCode;
    public int qqNum;
    public FriendRemark remark;
    public byte subCommand;
    public boolean hasRemark;
    public Map<Integer, FriendRemark> remarks;

    public FriendDataOpReplyPacket(ByteBuffer byteBuffer, int n, QQUser qQUser) throws PacketParseException {
        super(byteBuffer, n, qQUser);
    }

    public String getPacketName() {
        switch (this.subCommand) {
            case 0: {
                return "Friend Data Reply _08Packet - Batch Download Remark";
            }
            case 1: {
                return "Friend Data Reply _08Packet - Upload Remark";
            }
            case 3: {
                return "Friend Data Reply _08Packet - Download Remark";
            }
            case 2: {
                return "Friend Data Reply _08Packet - Remove Friend From List";
            }
        }
        return "Friend Data Reply Packeet - Unknown Sub Command";
    }

    protected void parseBody(ByteBuffer byteBuffer) throws PacketParseException {
        this.subCommand = byteBuffer.get();
        switch (this.subCommand) {
            case 0: {
                this.hasRemark = byteBuffer.get() == 0;
                this.remarks = new HashMap<Integer, FriendRemark>();
                while (byteBuffer.hasRemaining()) {
                    int n = byteBuffer.getInt();
                    byteBuffer.get();
                    FriendRemark friendRemark = new FriendRemark();
                    friendRemark.readBean(byteBuffer);
                    this.remarks.put(n, friendRemark);
                }
                break;
            }
            case 1: 
            case 2: {
                this.replyCode = byteBuffer.get();
                break;
            }
            case 3: {
                if (byteBuffer.hasRemaining()) {
                    this.qqNum = byteBuffer.getInt();
                    this.remark = new FriendRemark();
                    byteBuffer.get();
                    this.remark.readBean(byteBuffer);
                    this.hasRemark = true;
                    break;
                }
                this.hasRemark = false;
            }
        }
    }
}

