/*
 * Decompiled with CFR 0.152.
 */
package org.hn.sleek.jmml;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.hn.sleek.jmml.ContactList;
import org.hn.sleek.jmml.Message;

class IncomingMessage
extends Message {
    IncomingMessage() {
    }

    static IncomingMessage parseMessage(String incomingMessage) throws ParseException, NoSuchElementException {
        if (incomingMessage == null) {
            throw new ParseException("IncomingMessage.parseMessage() - Null message received", 1);
        }
        StringTokenizer st = new StringTokenizer(incomingMessage);
        IncomingMessage message = new IncomingMessage();
        try {
            String command = st.nextToken();
            message.type = Message.parseCommand(command);
            message.arguments.add(command);
        }
        catch (ParseException e) {
            System.err.println("IncomingMessage.parseMessage() - " + e);
            throw e;
        }
        catch (NoSuchElementException e) {
            System.err.println("IncomingMessage.parseMessage() - " + e);
            throw e;
        }
        switch (message.type) {
            case 2: 
            case 5: 
            case 6: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 17: 
            case 18: 
            case 23: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 35: {
                String tid = st.nextToken();
                message.arguments.add(tid);
                try {
                    message.transactionID = new Integer(tid);
                    break;
                }
                catch (NumberFormatException e) {
                    boolean bResult;
                    boolean bl = bResult = message.type != 18 && message.type != 6 && message.type != 5 && message.type != 23 && message.type != 12;
                    if (!bResult) break;
                    throw new ParseException("Invalid transaction ID", 1);
                }
            }
            case 38: {
                String tid = st.nextToken();
                message.arguments.add(tid);
                try {
                    message.transactionID = new Integer(tid);
                    break;
                }
                catch (NumberFormatException e) {
                    message.arguments.add(tid);
                }
            }
        }
        while (st.hasMoreTokens()) {
            String argument = st.nextToken();
            message.arguments.add(argument);
        }
        return message;
    }

    String getProtocols() throws NoSuchFieldException {
        switch (this.type) {
            case 32: {
                String protocolList = "";
                for (int i = 0; i < this.arguments.size(); ++i) {
                    if (i < 2) continue;
                    protocolList = protocolList + (String)this.arguments.get(i) + " ";
                }
                return protocolList;
            }
        }
        throw new NoSuchFieldException(IncomingMessage.commandToString(this.type) + " message types don't have a protocol list.");
    }

    String getSecurityProtocol() throws NoSuchFieldException {
        switch (this.type) {
            case 31: {
                return (String)this.arguments.get(2);
            }
        }
        throw new NoSuchFieldException(IncomingMessage.commandToString(this.type) + " messages don't have security protocol.");
    }

    String getFriendlyName() throws NoSuchFieldException {
        String strValue;
        Object objValue;
        switch (this.type) {
            case 18: 
            case 19: {
                objValue = this.arguments.get(2);
                break;
            }
            case 21: {
                objValue = this.arguments.get(3);
                break;
            }
            case 13: 
            case 25: 
            case 31: {
                objValue = this.arguments.get(4);
                break;
            }
            case 2: {
                objValue = this.arguments.get(5);
                break;
            }
            case 29: {
                objValue = this.arguments.get(6);
                break;
            }
            default: {
                throw new NoSuchFieldException(IncomingMessage.commandToString(this.type) + " messages don't have friendlyname.");
            }
        }
        try {
            strValue = objValue != null ? URLDecoder.decode((String)objValue, "UTF-8") : "";
        }
        catch (UnsupportedEncodingException e) {
            System.err.println("IncomingMessage.getFriendlyName() - " + e);
            strValue = "";
        }
        return strValue;
    }

    String getUserName() throws NoSuchFieldException {
        switch (this.type) {
            case 11: 
            case 19: {
                return (String)this.arguments.get(1);
            }
            case 6: 
            case 21: {
                return (String)this.arguments.get(2);
            }
            case 13: 
            case 25: 
            case 31: {
                return (String)this.arguments.get(3);
            }
            case 2: 
            case 27: {
                return (String)this.arguments.get(4);
            }
            case 29: {
                return (String)this.arguments.get(5);
            }
            case 18: {
                Object objValue = this.arguments.get(1);
                return objValue != null ? (String)objValue : "";
            }
        }
        throw new NoSuchFieldException(IncomingMessage.commandToString(this.type) + " messages don't have username.");
    }

    String getPRPParameter() throws NoSuchFieldException {
        switch (this.type) {
            case 23: {
                String strParm;
                try {
                    strParm = (String)this.arguments.get(4);
                }
                catch (IndexOutOfBoundsException e) {
                    strParm = null;
                }
                if (strParm == null) {
                    try {
                        strParm = (String)this.arguments.get(2);
                    }
                    catch (IndexOutOfBoundsException e) {
                        strParm = null;
                    }
                }
                return strParm != null ? strParm : "";
            }
        }
        throw new NoSuchFieldException(IncomingMessage.commandToString(this.type) + " messages don't have a Phone number");
    }

    boolean isMOB() {
        switch (this.type) {
            case 23: {
                String strMOB;
                try {
                    strMOB = (String)this.arguments.get(3);
                }
                catch (IndexOutOfBoundsException e) {
                    strMOB = null;
                }
                if (strMOB == null) {
                    try {
                        strMOB = (String)this.arguments.get(1);
                    }
                    catch (IndexOutOfBoundsException e) {
                        strMOB = null;
                    }
                }
                return strMOB != null ? strMOB.compareTo("MOB") == 0 : false;
            }
        }
        return false;
    }

    boolean isMBE() {
        switch (this.type) {
            case 23: {
                String strMBE;
                try {
                    strMBE = (String)this.arguments.get(3);
                }
                catch (IndexOutOfBoundsException e) {
                    strMBE = null;
                }
                if (strMBE == null) {
                    try {
                        strMBE = (String)this.arguments.get(1);
                    }
                    catch (IndexOutOfBoundsException e) {
                        strMBE = null;
                    }
                }
                return strMBE != null ? strMBE.compareTo("MBE") == 0 : false;
            }
        }
        return false;
    }

    int getPhoneType() throws NoSuchFieldException {
        switch (this.type) {
            case 23: {
                String strPhoneType = (String)this.arguments.get(3);
                if (strPhoneType.compareTo("PHH") == 0) {
                    return 1;
                }
                if (strPhoneType.compareTo("PHW") == 0) {
                    return 2;
                }
                if (strPhoneType.compareTo("PHM") != 0) break;
                return 3;
            }
        }
        throw new NoSuchFieldException(IncomingMessage.commandToString(this.type) + " messages don't have a Phone number");
    }

    String getProperty() throws NoSuchFieldException {
        switch (this.type) {
            case 6: {
                return (String)this.arguments.get(3);
            }
        }
        throw new NoSuchFieldException(IncomingMessage.commandToString(this.type) + " messages don't have properties.");
    }

    String getValue() throws NoSuchFieldException {
        switch (this.type) {
            case 6: {
                try {
                    return (String)this.arguments.get(4);
                }
                catch (IndexOutOfBoundsException e) {
                    return null;
                }
            }
        }
        throw new NoSuchFieldException(IncomingMessage.commandToString(this.type) + " message don't have property values.");
    }

    String getReferralType() throws NoSuchFieldException {
        switch (this.type) {
            case 33: {
                return (String)this.arguments.get(2);
            }
        }
        throw new NoSuchFieldException(IncomingMessage.commandToString(this.type) + " messages don't have referraltype.");
    }

    String getServerIP() throws NoSuchFieldException {
        switch (this.type) {
            case 29: {
                String serverIP = (String)this.arguments.get(2);
                return serverIP.indexOf(":") > -1 ? serverIP.substring(0, serverIP.indexOf(":")) : serverIP;
            }
            case 33: {
                String serverIP = (String)this.arguments.get(3);
                return serverIP.indexOf(":") > -1 ? serverIP.substring(0, serverIP.indexOf(":")) : serverIP;
            }
        }
        throw new NoSuchFieldException(IncomingMessage.commandToString(this.type) + " messages don't have an IP address.");
    }

    int getServerPort() throws NoSuchFieldException {
        switch (this.type) {
            case 29: {
                String serverIP = (String)this.arguments.get(2);
                if (serverIP.indexOf(":") > -1) {
                    try {
                        return Integer.parseInt(serverIP.substring(serverIP.indexOf(":") + 1));
                    }
                    catch (NumberFormatException e) {
                        return 1863;
                    }
                }
                return 1863;
            }
            case 33: {
                String serverIP = (String)this.arguments.get(3);
                if (serverIP.indexOf(":") > -1) {
                    try {
                        return Integer.parseInt(serverIP.substring(serverIP.indexOf(":") + 1));
                    }
                    catch (NumberFormatException e) {
                        return 1863;
                    }
                }
                return 1863;
            }
        }
        throw new NoSuchFieldException(IncomingMessage.commandToString(this.type) + " messages don't have port numbers.");
    }

    int getSerialNumber() throws NoSuchFieldException {
        switch (this.type) {
            case 6: {
                try {
                    return Integer.parseInt((String)this.arguments.get(1));
                }
                catch (NumberFormatException e) {
                    return -1;
                }
            }
            case 5: 
            case 12: 
            case 17: 
            case 23: 
            case 25: 
            case 26: 
            case 28: 
            case 30: {
                try {
                    return Integer.parseInt((String)this.arguments.get(2));
                }
                catch (NumberFormatException e) {
                    return -1;
                }
            }
            case 2: 
            case 18: 
            case 27: {
                try {
                    return Integer.parseInt((String)this.arguments.get(3));
                }
                catch (NumberFormatException e) {
                    return -1;
                }
            }
        }
        throw new NoSuchFieldException(IncomingMessage.commandToString(this.type) + " messages don't have a serial number.");
    }

    String getStatus() throws NoSuchFieldException {
        String rawStatus = "";
        switch (this.type) {
            case 11: {
                rawStatus = "FLN";
                break;
            }
            case 21: {
                rawStatus = (String)this.arguments.get(1);
                break;
            }
            case 9: 
            case 13: {
                rawStatus = (String)this.arguments.get(2);
                break;
            }
            default: {
                throw new NoSuchFieldException(IncomingMessage.commandToString(this.type) + " messages don't have a status.");
            }
        }
        return rawStatus;
    }

    Hashtable getListType() throws NoSuchFieldException {
        switch (this.type) {
            case 18: {
                return ContactList.parseListType((String)this.arguments.get(3));
            }
            case 2: 
            case 27: {
                return ContactList.parseListType((String)this.arguments.get(2));
            }
        }
        throw new NoSuchFieldException(IncomingMessage.commandToString(this.type) + " messages don't have list type.");
    }

    int getItemNumber() throws NoSuchFieldException {
        switch (this.type) {
            case 17: {
                try {
                    return Integer.parseInt((String)this.arguments.get(3));
                }
                catch (NumberFormatException e) {
                    return -1;
                }
            }
            case 18: {
                try {
                    return Integer.parseInt((String)this.arguments.get(4));
                }
                catch (NumberFormatException e) {
                    return -1;
                }
            }
        }
        throw new NoSuchFieldException(IncomingMessage.commandToString(this.type) + " messages don't have item number.");
    }

    int getTotalItems() throws NoSuchFieldException {
        switch (this.type) {
            case 17: {
                try {
                    return Integer.parseInt((String)this.arguments.get(4));
                }
                catch (NumberFormatException e) {
                    return -1;
                }
            }
            case 18: {
                try {
                    return Integer.parseInt((String)this.arguments.get(5));
                }
                catch (NumberFormatException e) {
                    return -1;
                }
            }
        }
        throw new NoSuchFieldException(IncomingMessage.commandToString(this.type) + " messages don't have totalitems.");
    }

    ArrayList getGroups() {
        switch (this.type) {
            case 18: {
                if (this.arguments.size() > 4) {
                    StringTokenizer parser = new StringTokenizer((String)this.arguments.get(4), ",");
                    ArrayList<Integer> aGroups = new ArrayList<Integer>();
                    try {
                        while (parser.hasMoreTokens()) {
                            Integer iValue = new Integer(Integer.parseInt(parser.nextToken()));
                            aGroups.add(iValue);
                        }
                    }
                    catch (NoSuchElementException ex) {
                        System.err.println("IncomingMessage.getGroups() - " + ex);
                    }
                    return aGroups;
                }
                return null;
            }
            case 17: {
                try {
                    ArrayList<Integer> aGroups = new ArrayList<Integer>();
                    Integer iValue = new Integer(Integer.parseInt((String)this.arguments.get(1)));
                    aGroups.add(iValue);
                    return aGroups;
                }
                catch (Exception ex) {
                    return null;
                }
            }
        }
        return null;
    }

    String getGroupName() {
        switch (this.type) {
            case 3: 
            case 26: {
                try {
                    try {
                        return URLDecoder.decode(this.arguments.get(this.type == 3 ? 3 : 4).toString(), "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        return "None";
                    }
                }
                catch (Exception ex) {
                    return "None";
                }
            }
            case 17: {
                try {
                    try {
                        return URLDecoder.decode(this.arguments.get(2).toString(), "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        return "None";
                    }
                }
                catch (Exception ex) {
                    return "None";
                }
            }
        }
        return "None";
    }

    int getGroupId() {
        switch (this.type) {
            case 2: 
            case 27: {
                try {
                    Integer iValue = new Integer(Integer.parseInt((String)this.arguments.get(this.type == 27 ? 5 : 6)));
                    return iValue;
                }
                catch (Exception e) {
                    System.err.println("IncomingMessage.getGroupId() - Invalid group id assuming group id = 0");
                    return 0;
                }
            }
            case 3: 
            case 26: 
            case 28: {
                try {
                    Integer iValue = new Integer(Integer.parseInt((String)this.arguments.get(this.type == 3 ? 4 : (this.type == 26 ? 3 : 1))));
                    return iValue;
                }
                catch (Exception e) {
                    System.err.println("IncomingMessage.getGroupId() - Invalid group id assuming group id = 0");
                    return 0;
                }
            }
        }
        System.err.println("IncomingMessage.getGroupId() - Invalid message processing");
        return 0;
    }

    boolean getReverseListBehaviour() throws NoSuchFieldException {
        switch (this.type) {
            case 12: {
                String strRet;
                try {
                    strRet = (String)this.arguments.get(3);
                }
                catch (IndexOutOfBoundsException e) {
                    strRet = (String)this.arguments.get(1);
                }
                return strRet.compareTo("N") == 0;
            }
        }
        throw new NoSuchFieldException(IncomingMessage.commandToString(this.type) + " messages don't have a GTC argument.");
    }

    boolean getPrivacyMode() throws NoSuchFieldException {
        switch (this.type) {
            case 5: {
                String strRet;
                try {
                    strRet = (String)this.arguments.get(3);
                }
                catch (IndexOutOfBoundsException e) {
                    strRet = (String)this.arguments.get(1);
                }
                return strRet.compareTo("AL") == 0;
            }
        }
        throw new NoSuchFieldException(IncomingMessage.commandToString(this.type) + " message don't have a BLP argument.");
    }

    String getChallengeHash() throws NoSuchFieldException {
        switch (this.type) {
            case 10: {
                return (String)this.arguments.get(2);
            }
            case 29: 
            case 31: {
                Object objValue = this.arguments.get(4);
                return objValue != null ? (String)objValue : "";
            }
            case 33: {
                try {
                    return (String)this.arguments.get(5);
                }
                catch (IndexOutOfBoundsException e) {
                    return null;
                }
            }
        }
        throw new NoSuchFieldException(IncomingMessage.commandToString(this.type) + " messages don't have a challenge hash.");
    }

    String getSessionID() throws NoSuchFieldException {
        switch (this.type) {
            case 29: {
                return (String)this.arguments.get(1);
            }
            case 8: {
                return (String)this.arguments.get(3);
            }
        }
        throw new NoSuchFieldException(IncomingMessage.commandToString(this.type) + " messages don't have a session id.");
    }

    String getExitStatus() throws NoSuchFieldException {
        switch (this.type) {
            case 22: {
                try {
                    return (String)this.arguments.get(1);
                }
                catch (IndexOutOfBoundsException e) {
                    return "";
                }
            }
        }
        throw new NoSuchFieldException(IncomingMessage.commandToString(this.type) + " messages don't have exit status.");
    }

    int getErrorCode() throws NoSuchFieldException {
        if (this.type != 38) {
            throw new NoSuchFieldException(IncomingMessage.commandToString(this.type) + " isn't an error code.");
        }
        try {
            return Integer.parseInt((String)this.arguments.get(0));
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    int getBodyLength() throws NoSuchFieldException {
        switch (this.type) {
            case 19: {
                try {
                    return Integer.parseInt((String)this.arguments.get(3));
                }
                catch (NumberFormatException e) {
                    return 0;
                }
            }
        }
        throw new NoSuchFieldException(IncomingMessage.commandToString(this.type) + " messages don't have a body length.");
    }

    long getClientId() throws NoSuchFieldException {
        switch (this.type) {
            case 9: 
            case 13: 
            case 21: {
                try {
                    return Long.parseLong((String)this.arguments.get(this.type == 9 ? 3 : (this.type == 13 ? 5 : 4)));
                }
                catch (NumberFormatException e) {
                    return 0L;
                }
            }
        }
        throw new NoSuchFieldException(IncomingMessage.commandToString(this.type) + " messages don't have a ClientID.");
    }

    long getContactListVersion() throws NoSuchFieldException {
        switch (this.type) {
            case 30: {
                try {
                    return Long.parseLong((String)this.arguments.get(1));
                }
                catch (NumberFormatException e) {
                    return 0L;
                }
            }
        }
        throw new NoSuchFieldException(IncomingMessage.commandToString(this.type) + " messages don't have a contact list version.");
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            System.out.println("Test the arg for validity.");
        }
        String[] cmds = new String[]{"ADD 0 RL 105 example@passport.com Mike", "ADD 0 RL 105 example@passport.com Mike", "BLP 54 12182 AL", "BPR 12182 example@passport.com MOB N", "BPR 12182 example@passport.com MOB N", "BPR 12182 example@passport.com PHH", "BPR 12182 example@passport.com PHH", "BPR 12182 example@passport.com PHM I%20Dont%20Have%20One", "BPR 12182 example@passport.com PHM I%20Dont%20Have%20One", "BPR 12182 example@passport.com PHW 555%20555-1234", "BPR 12182 example@passport.com PHW 555%20555-1234", "BPR 12182 myname@msn.com MOB N", "BPR 12182 myname@msn.com MOB Y", "BPR 12182 myname@msn.com MOB Y", "BPR 12182 myname@msn.com PHH", "BPR 12182 myname@msn.com PHH 555%20555%204321", "BPR 12182 myname@msn.com PHH 555%20555%204321", "BPR 12182 myname@msn.com PHM", "BPR 12182 myname@msn.com PHM", "BPR 12182 myname@msn.com PHM", "BPR 12182 myname@msn.com PHW", "BPR 12182 myname@msn.com PHW I%20AM%20DUMB", "BPR 12182 myname@msn.com PHW I%20AM%20DUMB", "CHG 10 HDN", "CHG 7 NLN", "CHG 8 AWY", "CHG 9 NLN", "CHL 0 15570131571988941333", "FLN name_123@hotmail.com", "GTC 54 12182 A", "ILN 7 AWY example@passport.com Mike", "ILN 7 BSY myname@msn.com My%20Name", "ILN 7 NLN name_123@hotmail.com Name_123", "INF 1 MD5", "INF 4 MD5", "LSG 54 12182 1 3 0 Other%20Contacts 0", "LSG 54 12182 1 3 0 Other%20Contacts 0", "LSG 54 12182 2 3 2 Group1 0", "LSG 54 12182 2 3 2 Group1 0", "LSG 54 12182 3 3 5 Group2 0", "LSG 54 12182 3 3 5 Group2 0", "LST 10 FL 21 1 3 example@passport.com Mike 0", "LST 10 FL 21 2 3 name_123@hotmail.com Name_123 2", "LST 10 FL 21 2 3 name_123@hotmail.com Name_123 2", "LST 10 FL 21 3 3 myname@msn.com My%20Name 0", "LST 11 BL 3 0 0", "LST 54 AL 12182 1 3 myname@msn.com My%20Name", "LST 54 AL 12182 2 3 example@passport.com Mike", "LST 54 AL 12182 3 3 name_123@hotmail.com Name_123", "LST 54 BL 12182 0 0", "LST 54 FL 12182 1 2 example@passport.com Mike 0", "LST 54 FL 12182 1 2 example@passport.com Mike 0", "LST 54 FL 12182 2 2 myname@msn.com My%20Name 2", "LST 54 FL 12182 2 2 myname@msn.com Name_123 2", "LST 54 RL 12182 1 2 myname@msn.com My%20Name", "NLN AWY example@passport.com Mike", "NLN NLN myname@msn.com My%20Name", "OUT", "OUT OTH", "OUT SSD", "PRP 54 12182 MBE N", "PRP 54 12182 MBE N", "PRP 54 12182 MOB Y", "PRP 54 12182 MOB Y", "PRP 54 12182 PHH 555%20555-0690", "PRP 54 12182 PHH 555%20555-0690", "PRP 54 12182 PHM", "PRP 54 12182 PHM", "PRP 54 12182 PHW", "PRP 54 12182 PHW", "PRP 55 12183 PHH 555%20555-0690", "PRP 56 12184 PHW 555%20555-0691", "QRY 10", "REA 25 115 example@passport.com My%20New%20Name", "REG 25 12066 15 New%20Name 0", "REM 0 RL 106 example@passport.com", "RMG 24 12065 15", "RNG 11752099 64.4.12.193:1863 CKI 849102291.520491932 myname@msn.com My%20Name", "SYN 54 12182", "USR 5 MD5 S 1013928519.693957190", "USR 6 OK example@passport.com My%20Screen%20Name 1", "VER 0 MSNP7 MSNP6 MSNP5 MSNP4 CVR0", "VER 3 MSNP7 MSNP6 MSNP5 MSNP4 CVR0", "XFR 10 SB 64.4.12.193:1863 CKI 16925950.1016955577.17693", "XFR 2 NS 64.4.12.132:1862 0", "XFR 2 NS 64.4.12.133 0", "911 It's over dude", "220 Bad Call"};
        System.out.println("*-*-*-*-*-*-*-*-*-*-*");
        for (int i = 0; i < cmds.length; ++i) {
            System.out.println("----------------");
            try {
                System.out.println("Original: " + cmds[i]);
                IncomingMessage msg = IncomingMessage.parseMessage(cmds[i]);
                System.out.println(">> getProperty: " + msg.getProperty());
                System.out.println(">> getValue: " + msg.getValue());
                continue;
            }
            catch (Exception e) {
                System.out.println("Error: " + e);
            }
        }
    }
}

