/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Enumeration;
import java.util.List;
import org.apache.commons.logging.Log;
import org.mortbay.http.EOFException;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpException;
import org.mortbay.http.HttpInputStream;
import org.mortbay.http.HttpListener;
import org.mortbay.http.HttpOutputStream;
import org.mortbay.http.HttpRequest;
import org.mortbay.http.HttpResponse;
import org.mortbay.http.HttpServer;
import org.mortbay.http.HttpTunnel;
import org.mortbay.http.Version;
import org.mortbay.log.LogFactory;
import org.mortbay.util.LineInput;
import org.mortbay.util.LogSupport;
import org.mortbay.util.OutputObserver;
import org.mortbay.util.StringUtil;

public class HttpConnection
implements OutputObserver {
    private static Log log = LogFactory.getLog(class$org$mortbay$http$HttpConnection == null ? (class$org$mortbay$http$HttpConnection = HttpConnection.class$("org.mortbay.http.HttpConnection")) : class$org$mortbay$http$HttpConnection);
    private static ThreadLocal __threadConnection = new ThreadLocal();
    private static boolean __2068_Continues = Boolean.getBoolean("org.mortbay.http.HttpConnection.2068Continue");
    protected HttpRequest _request;
    protected HttpResponse _response;
    protected boolean _persistent;
    protected boolean _keepAlive;
    protected int _dotVersion;
    private HttpListener _listener;
    private HttpInputStream _inputStream;
    private HttpOutputStream _outputStream;
    private boolean _close;
    private boolean _firstWrite;
    private boolean _completing;
    private Thread _handlingThread;
    private InetAddress _remoteInetAddress;
    private String _remoteAddr;
    private String _remoteHost;
    private HttpServer _httpServer;
    private Object _connection;
    private boolean _throttled;
    private boolean _statsOn;
    private long _tmpTime;
    private long _openTime;
    private long _reqTime;
    private int _requests;
    private Object _object;
    private HttpTunnel _tunnel;
    private boolean _resolveRemoteHost;
    static /* synthetic */ Class class$org$mortbay$http$HttpConnection;

    public HttpConnection(HttpListener listener, InetAddress remoteAddr, InputStream in, OutputStream out, Object connection) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("new HttpConnection: " + connection));
        }
        this._listener = listener;
        this._remoteInetAddress = remoteAddr;
        int bufferSize = listener == null ? 4096 : listener.getBufferSize();
        int reserveSize = listener == null ? 512 : listener.getBufferReserve();
        this._inputStream = new HttpInputStream(in, bufferSize);
        this._outputStream = new HttpOutputStream(out, bufferSize, reserveSize);
        this._outputStream.addObserver(this);
        this._firstWrite = false;
        if (this._listener != null) {
            this._httpServer = this._listener.getHttpServer();
        }
        this._connection = connection;
        boolean bl = this._statsOn = this._httpServer != null && this._httpServer.getStatsOn();
        if (this._statsOn) {
            this._openTime = System.currentTimeMillis();
            this._httpServer.statsOpenConnection();
        }
        this._reqTime = 0L;
        this._requests = 0;
        this._request = new HttpRequest(this);
        this._response = new HttpResponse(this);
        this._resolveRemoteHost = this._listener != null && this._listener.getHttpServer() != null && this._listener.getHttpServer().getResolveRemoteHost();
    }

    static HttpConnection getHttpConnection() {
        return (HttpConnection)__threadConnection.get();
    }

    public InetAddress getRemoteInetAddress() {
        return this._remoteInetAddress;
    }

    public String getRemoteAddr() {
        if (this._remoteAddr == null) {
            if (this._remoteInetAddress == null) {
                return "127.0.0.1";
            }
            this._remoteAddr = this._remoteInetAddress.getHostAddress();
        }
        return this._remoteAddr;
    }

    public String getRemoteHost() {
        if (this._remoteHost == null) {
            if (this._resolveRemoteHost) {
                if (this._remoteInetAddress == null) {
                    return "localhost";
                }
                this._remoteHost = this._remoteInetAddress.getHostName();
            } else {
                if (this._remoteInetAddress == null) {
                    return "127.0.0.1";
                }
                this._remoteHost = this.getRemoteAddr();
            }
        }
        return this._remoteHost;
    }

    public HttpInputStream getInputStream() {
        return this._inputStream;
    }

    public HttpOutputStream getOutputStream() {
        return this._outputStream;
    }

    public Object getConnection() {
        return this._connection;
    }

    public HttpRequest getRequest() {
        return this._request;
    }

    public HttpResponse getResponse() {
        return this._response;
    }

    public void forceClose() {
        this._persistent = false;
        this._close = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        try {
            this._completing = true;
            this._outputStream.close();
            this._inputStream.close();
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (this._handlingThread != null && Thread.currentThread() != this._handlingThread) {
                this._handlingThread.interrupt();
            }
            throw throwable;
        }
        if (this._handlingThread != null && Thread.currentThread() != this._handlingThread) {
            this._handlingThread.interrupt();
        }
    }

    public HttpListener getListener() {
        return this._listener;
    }

    public HttpServer getHttpServer() {
        return this._httpServer;
    }

    public String getDefaultScheme() {
        return this._listener.getDefaultScheme();
    }

    public String getServerName() {
        String host = this._listener.getHost();
        if ("0.0.0.0".equals(host) && this._connection instanceof Socket) {
            host = ((Socket)this._connection).getLocalAddress().getHostName();
        }
        return host;
    }

    public String getServerAddr() {
        if (this._connection instanceof Socket) {
            return ((Socket)this._connection).getLocalAddress().getHostAddress();
        }
        return this._listener.getHost();
    }

    public int getServerPort() {
        return this._listener.getPort();
    }

    public int getRemotePort() {
        if (this._connection instanceof Socket) {
            return ((Socket)this._connection).getPort();
        }
        return 0;
    }

    public boolean isThrottled() {
        return this._throttled;
    }

    public void setThrottled(boolean throttled) {
        this._throttled = throttled;
    }

    public Object getObject() {
        return this._object;
    }

    public void setObject(Object o) {
        this._object = o;
    }

    public HttpTunnel getHttpTunnel() {
        return this._tunnel;
    }

    public void setHttpTunnel(HttpTunnel tunnel) {
        this._tunnel = tunnel;
    }

    private void verifyHTTP_1_0() {
        int content_length = this._request.getIntField("Content-Length");
        if (content_length >= 0) {
            this._inputStream.setContentLength(content_length);
        } else if (content_length < 0) {
            this._inputStream.setContentLength(0);
        }
        if (!this._keepAlive && "keep-alive".equalsIgnoreCase(this._request.getField("Proxy-Connection"))) {
            this._keepAlive = true;
        }
        this._persistent = this._keepAlive;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void verifyHTTP_1_1() throws HttpException, IOException {
        String expect;
        String host = this._request.getField("Host");
        if (host == null) {
            throw new HttpException(400);
        }
        String transfer_coding = this._request.getField("Transfer-Encoding");
        if (transfer_coding != null && transfer_coding.length() > 0) {
            if (transfer_coding.equalsIgnoreCase("chunked") || StringUtil.endsWithIgnoreCase(transfer_coding, "chunked")) {
                this._inputStream.setChunking();
            } else if (StringUtil.asciiToLowerCase(transfer_coding).indexOf("chunked") >= 0) {
                throw new HttpException(400);
            }
        }
        int content_length = this._request.getIntField("Content-Length");
        String content_type = this._request.getField("Content-Type");
        if (!this._inputStream.isChunking()) {
            if (content_length >= 0) {
                this._inputStream.setContentLength(content_length);
            } else if (content_type == null || content_type.length() == 0) {
                this._inputStream.setContentLength(0);
            } else {
                this._inputStream.setContentLength(0);
            }
        }
        if ((expect = this._request.getField("Expect")) != null && expect.length() > 0) {
            if (!StringUtil.asciiToLowerCase(expect).equals("100-continue")) throw new HttpException(417);
            this._inputStream.setExpectContinues(this._outputStream.getOutputStream());
        } else if (__2068_Continues && this._inputStream.available() <= 0 && ("PUT".equals(this._request.getMethod()) || "POST".equals(this._request.getMethod()))) {
            OutputStream real_out = this._outputStream.getOutputStream();
            real_out.write(HttpResponse.__Continue);
            real_out.flush();
        }
        this._persistent = !this._close;
    }

    public void outputNotify(OutputStream out, int action, Object ignoredData) throws IOException {
        if (this._response == null) {
            return;
        }
        switch (action) {
            case 0: {
                if (this._firstWrite) break;
                this.firstWrite();
                this._firstWrite = true;
                break;
            }
            case 1: {
                this.resetBuffer();
                break;
            }
            case 2: {
                this.commit();
                break;
            }
            case 4: {
                if (this._response == null) break;
                this.completing();
                if (this._response.isCommitted() || this._request.getState() != 2) break;
                this.commit();
                break;
            }
        }
    }

    protected void firstWrite() throws IOException {
        int length;
        if (this._response.isCommitted()) {
            return;
        }
        if ("HEAD".equals(this._request.getMethod())) {
            this._outputStream.nullOutput();
        }
        if ((length = this._response.getIntField("Content-Length")) >= 0) {
            this._outputStream.setContentLength(length);
        }
    }

    private void resetBuffer() {
    }

    void completing() {
        this._completing = true;
    }

    protected void commit() throws IOException {
        if (this._response.isCommitted()) {
            return;
        }
        int status = this._response.getStatus();
        int length = -1;
        if (this._inputStream.getExpectContinues() != null) {
            this._inputStream.setExpectContinues(null);
            this._inputStream.unsafeSetContentLength(0);
        }
        boolean has_close = "close".equals(this._response.getField("Connection"));
        if (!this._persistent || this._close || this._listener != null && (!this._listener.isStarted() || this._listener.isOutOfResources())) {
            this._close = true;
            if (!has_close) {
                this._response.setField("Connection", "close");
            }
            has_close = true;
        }
        if (this._close) {
            this._persistent = false;
        }
        if (this._persistent) {
            switch (this._dotVersion) {
                case 1: {
                    String transfer_coding = this._response.getField("Transfer-Encoding");
                    if (transfer_coding == null || transfer_coding.length() == 0 || "identity".equalsIgnoreCase(transfer_coding)) {
                        if (status == 304 || status == 204 || this._response.getField("Content-Length") != null) break;
                        if (this._completing) {
                            length = this._outputStream.getBytesWritten();
                            this._response.setContentLength(length);
                            break;
                        }
                        this._response.setField("Transfer-Encoding", "chunked");
                        this._outputStream.setChunking();
                        break;
                    }
                    this._response.removeField("Content-Length");
                    this._outputStream.setChunking();
                    if ("chunked".equalsIgnoreCase(transfer_coding)) break;
                    List te = this._request.getAcceptableTransferCodings();
                    Enumeration enm = this._response.getFieldValues("Transfer-Encoding", ", \t");
                    while (enm.hasMoreElements()) {
                        String coding = (String)enm.nextElement();
                        if ("identity".equalsIgnoreCase(coding) || "chunked".equalsIgnoreCase(coding) || te != null && te.contains(coding)) continue;
                        throw new HttpException(501, coding);
                    }
                    break;
                }
                case 0: {
                    this._response.removeField("Transfer-Encoding");
                    if (this._keepAlive) {
                        if (status != 304 && status != 204 && this._response.getField("Content-Length") == null) {
                            if (this._completing) {
                                length = this._outputStream.getBytesWritten();
                                this._response.setContentLength(length);
                                this._response.setField("Connection", "keep-alive");
                                break;
                            }
                            this._response.setField("Connection", "close");
                            this._close = true;
                            has_close = true;
                            this._persistent = false;
                            break;
                        }
                        this._response.setField("Connection", "keep-alive");
                        break;
                    }
                    if (has_close) break;
                    this._response.setField("Connection", "close");
                    break;
                }
                default: {
                    this._close = true;
                    this._persistent = false;
                    this._keepAlive = false;
                }
            }
        }
        this._request.setHandled(true);
        this._outputStream.writeHeader(this._response);
        this._outputStream.flush();
    }

    private void exception(Throwable e) {
        try {
            this._persistent = false;
            int error_code = 500;
            if (e instanceof HttpException) {
                error_code = ((HttpException)e).getCode();
                if (this._request == null) {
                    log.warn((Object)e.toString());
                } else {
                    log.warn((Object)(this._request.getRequestLine() + " " + e.toString()));
                }
                log.debug((Object)"EXCEPTION ", e);
            } else {
                if (e instanceof EOFException) {
                    LogSupport.ignore(log, e);
                    return;
                }
                this._request.setAttribute("javax.servlet.error.exception_type", e.getClass());
                this._request.setAttribute("javax.servlet.error.exception", e);
                if (this._request == null) {
                    log.warn((Object)"EXCEPTION ", e);
                } else {
                    log.warn((Object)this._request.getRequestLine(), e);
                }
            }
            if (this._response != null && !this._response.isCommitted()) {
                this._response.reset();
                this._response.removeField("Transfer-Encoding");
                this._response.setField("Connection", "close");
                this._response.sendError(error_code);
            }
        }
        catch (Exception ex) {
            LogSupport.ignore(log, ex);
        }
    }

    protected HttpContext service(HttpRequest request, HttpResponse response) throws HttpException, IOException {
        if (this._httpServer == null) {
            throw new HttpException(503);
        }
        return this._httpServer.service(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void handle() {
        try {
            this.associateThread();
            while (this._listener.isStarted() && this.handleNext()) {
                this.recycle();
            }
        }
        finally {
            this.disassociateThread();
            this.destroy();
        }
    }

    protected void associateThread() {
        __threadConnection.set(this);
        this._handlingThread = Thread.currentThread();
    }

    protected void disassociateThread() {
        this._handlingThread = null;
        __threadConnection.set(null);
    }

    protected void readRequest() throws IOException {
        this._request.readHeader((LineInput)this._inputStream.getInputStream());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean handleNext() {
        block204: {
            int content_length222222222222222;
            int bytes_written222222222222222;
            Throwable throwable222;
            boolean stats;
            HttpContext context;
            block205: {
                block203: {
                    boolean no_continue_sent222222222222222;
                    int content_length222222222222222;
                    int bytes_written222222222222222;
                    block201: {
                        block198: {
                            boolean no_continue_sent222222222222222;
                            int content_length222222222222222;
                            int bytes_written222222222222222;
                            block196: {
                                block193: {
                                    boolean no_continue_sent222222222222222;
                                    int content_length222222222222222;
                                    int bytes_written222222222222222;
                                    block191: {
                                        block188: {
                                            boolean no_continue_sent222222222222222;
                                            int bytes_written222222222222222;
                                            block186: {
                                                block183: {
                                                    boolean no_continue_sent222222222222222;
                                                    int content_length222222222222222;
                                                    block178: {
                                                        Enumeration connectionValues;
                                                        block173: {
                                                            int content_length222222222222222;
                                                            if (this._tunnel != null) {
                                                                if (log.isDebugEnabled()) {
                                                                    log.debug((Object)("Tunnel: " + this._tunnel));
                                                                }
                                                                this._outputStream.resetObservers();
                                                                this._tunnel.handle(this._inputStream.getInputStream(), this._outputStream.getOutputStream());
                                                                return false;
                                                            }
                                                            context = null;
                                                            stats = false;
                                                            this._persistent = false;
                                                            this._close = false;
                                                            this._keepAlive = false;
                                                            this._firstWrite = false;
                                                            this._completing = false;
                                                            this._dotVersion = 0;
                                                            this.readRequest();
                                                            if (this._listener != null && this._listener.isStarted()) break block173;
                                                            this._response.destroy();
                                                            this._response = null;
                                                            this._persistent = false;
                                                            boolean bl = false;
                                                            Object var6_9 = null;
                                                            int bytes_written222222222222222 = 0;
                                                            int n = content_length222222222222222 = this._response == null ? -1 : this._response.getIntField("Content-Length");
                                                            if (this._persistent) {
                                                                boolean no_continue_sent222222222222222 = false;
                                                                try {
                                                                    if (this._inputStream.getExpectContinues() != null) {
                                                                        this._inputStream.setExpectContinues(null);
                                                                        no_continue_sent222222222222222 = true;
                                                                    } else {
                                                                        int remaining = this._inputStream.getContentLength();
                                                                        if (remaining != 0) {
                                                                            while (this._inputStream.skip(4096L) > 0L || this._inputStream.read() >= 0) {
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                                catch (IOException e2) {
                                                                    if (this._inputStream.getContentLength() > 0) {
                                                                        this._inputStream.setContentLength(0);
                                                                    }
                                                                    this._persistent = false;
                                                                    LogSupport.ignore(log, e2);
                                                                    this.exception(new HttpException(400, "Missing Content"));
                                                                }
                                                                if (!no_continue_sent222222222222222 && this._inputStream.getContentLength() > 0) {
                                                                    this._inputStream.setContentLength(0);
                                                                    this._persistent = false;
                                                                    this.exception(new HttpException(400, "Missing Content"));
                                                                }
                                                                try {
                                                                    this._outputStream.close();
                                                                    bytes_written222222222222222 = this._outputStream.getBytesWritten();
                                                                    this._outputStream.resetStream();
                                                                    this._outputStream.addObserver(this);
                                                                    this._inputStream.resetStream();
                                                                }
                                                                catch (IOException e) {
                                                                    this.exception(e);
                                                                }
                                                            } else if (this._response != null) {
                                                                try {
                                                                    if (this._inputStream.getContentLength() > 0) {
                                                                        while (this._inputStream.skip(4096L) > 0L || this._inputStream.read() >= 0) {
                                                                        }
                                                                    }
                                                                    this._inputStream.resetStream();
                                                                }
                                                                catch (IOException e) {
                                                                    LogSupport.ignore(log, e);
                                                                }
                                                                try {
                                                                    this._outputStream.flush();
                                                                    this._response.commit();
                                                                    bytes_written222222222222222 = this._outputStream.getBytesWritten();
                                                                    this._outputStream.close();
                                                                    this._outputStream.resetStream();
                                                                }
                                                                catch (IOException e) {
                                                                    this.exception(e);
                                                                }
                                                            }
                                                            if (this._response != null) {
                                                                if (log.isDebugEnabled()) {
                                                                    log.debug((Object)("RESPONSE:\n" + this._response));
                                                                }
                                                                if (this._persistent && content_length222222222222222 >= 0 && bytes_written222222222222222 > 0 && content_length222222222222222 != bytes_written222222222222222) {
                                                                    log.warn((Object)("Invalid length: Content-Length=" + content_length222222222222222 + " written=" + bytes_written222222222222222 + " for " + this._request.getRequestURL()));
                                                                    this._persistent = false;
                                                                    try {
                                                                        this._outputStream.close();
                                                                    }
                                                                    catch (IOException e) {
                                                                        log.warn((Object)"EXCEPTION ", (Throwable)e);
                                                                    }
                                                                }
                                                            }
                                                            if (stats) {
                                                                this.statsRequestEnd();
                                                            }
                                                            if (context != null) {
                                                                context.log(this._request, this._response, bytes_written222222222222222);
                                                            }
                                                            return bl;
                                                        }
                                                        this._listener.customizeRequest(this, this._request);
                                                        if (this._request.getState() != 2) {
                                                            throw new HttpException(400);
                                                        }
                                                        this.statsRequestStart();
                                                        stats = true;
                                                        this._dotVersion = this._request.getDotVersion();
                                                        if (this._dotVersion > 1) {
                                                            this._dotVersion = 1;
                                                        }
                                                        this._response.setVersion("HTTP/1.1");
                                                        this._response.setField("Date", this._request.getTimeStampStr());
                                                        if (!Version.isParanoid()) {
                                                            this._response.setField("Server", Version.getDetail());
                                                        }
                                                        if ((connectionValues = this._request.getFieldValues("Connection", ", \t")) != null) {
                                                            while (connectionValues.hasMoreElements()) {
                                                                String token = connectionValues.nextElement().toString();
                                                                if (token.equalsIgnoreCase("close")) {
                                                                    this._close = true;
                                                                    this._response.setField("Connection", "close");
                                                                } else if (token.equalsIgnoreCase("keep-alive") && this._dotVersion == 0) {
                                                                    this._keepAlive = true;
                                                                }
                                                                if (this._dotVersion != 0) continue;
                                                                this._request.forceRemoveField(token);
                                                            }
                                                        }
                                                        if (this._dotVersion == 1) {
                                                            this.verifyHTTP_1_1();
                                                        } else if (this._dotVersion == 0) {
                                                            this.verifyHTTP_1_0();
                                                        } else if (this._dotVersion != -1) {
                                                            throw new HttpException(505);
                                                        }
                                                        if (log.isDebugEnabled()) {
                                                            log.debug((Object)("REQUEST from " + this._listener + ":\n" + this._request));
                                                        }
                                                        if (!this._request.isHandled() && this._listener.getHttpHandler() != null) {
                                                            this._listener.getHttpHandler().handle("", null, this._request, this._response);
                                                        }
                                                        if (this._request.isHandled()) break block178;
                                                        context = this.service(this._request, this._response);
                                                    }
                                                    Object var6_10 = null;
                                                    int bytes_written222222222222222 = 0;
                                                    int n = content_length222222222222222 = this._response == null ? -1 : this._response.getIntField("Content-Length");
                                                    if (this._persistent) {
                                                        boolean no_continue_sent222222222222222 = false;
                                                        try {
                                                            if (this._inputStream.getExpectContinues() != null) {
                                                                this._inputStream.setExpectContinues(null);
                                                                no_continue_sent222222222222222 = true;
                                                            } else {
                                                                int remaining = this._inputStream.getContentLength();
                                                                if (remaining != 0) {
                                                                    while (this._inputStream.skip(4096L) > 0L || this._inputStream.read() >= 0) {
                                                                    }
                                                                }
                                                            }
                                                        }
                                                        catch (IOException e2) {
                                                            if (this._inputStream.getContentLength() > 0) {
                                                                this._inputStream.setContentLength(0);
                                                            }
                                                            this._persistent = false;
                                                            LogSupport.ignore(log, e2);
                                                            this.exception(new HttpException(400, "Missing Content"));
                                                        }
                                                        if (!no_continue_sent222222222222222 && this._inputStream.getContentLength() > 0) {
                                                            this._inputStream.setContentLength(0);
                                                            this._persistent = false;
                                                            this.exception(new HttpException(400, "Missing Content"));
                                                        }
                                                        try {
                                                            this._outputStream.close();
                                                            bytes_written222222222222222 = this._outputStream.getBytesWritten();
                                                            this._outputStream.resetStream();
                                                            this._outputStream.addObserver(this);
                                                            this._inputStream.resetStream();
                                                        }
                                                        catch (IOException e) {
                                                            this.exception(e);
                                                        }
                                                    } else if (this._response != null) {
                                                        try {
                                                            if (this._inputStream.getContentLength() > 0) {
                                                                while (this._inputStream.skip(4096L) > 0L || this._inputStream.read() >= 0) {
                                                                }
                                                            }
                                                            this._inputStream.resetStream();
                                                        }
                                                        catch (IOException e) {
                                                            LogSupport.ignore(log, e);
                                                        }
                                                        try {
                                                            this._outputStream.flush();
                                                            this._response.commit();
                                                            bytes_written222222222222222 = this._outputStream.getBytesWritten();
                                                            this._outputStream.close();
                                                            this._outputStream.resetStream();
                                                        }
                                                        catch (IOException e) {
                                                            this.exception(e);
                                                        }
                                                    }
                                                    if (this._response != null) {
                                                        if (log.isDebugEnabled()) {
                                                            log.debug((Object)("RESPONSE:\n" + this._response));
                                                        }
                                                        if (this._persistent && content_length222222222222222 >= 0 && bytes_written222222222222222 > 0 && content_length222222222222222 != bytes_written222222222222222) {
                                                            log.warn((Object)("Invalid length: Content-Length=" + content_length222222222222222 + " written=" + bytes_written222222222222222 + " for " + this._request.getRequestURL()));
                                                            this._persistent = false;
                                                            try {
                                                                this._outputStream.close();
                                                            }
                                                            catch (IOException e) {
                                                                log.warn((Object)"EXCEPTION ", (Throwable)e);
                                                            }
                                                        }
                                                    }
                                                    if (stats) {
                                                        this.statsRequestEnd();
                                                    }
                                                    if (context != null) {
                                                        context.log(this._request, this._response, bytes_written222222222222222);
                                                    }
                                                    break block204;
                                                    {
                                                        catch (HttpException e) {
                                                            this.exception(e);
                                                            Object var6_11 = null;
                                                            bytes_written222222222222222 = 0;
                                                            int n2 = content_length222222222222222 = this._response == null ? -1 : this._response.getIntField("Content-Length");
                                                            if (!this._persistent) break block183;
                                                            no_continue_sent222222222222222 = false;
                                                            try {
                                                                if (this._inputStream.getExpectContinues() != null) {
                                                                    this._inputStream.setExpectContinues(null);
                                                                    no_continue_sent222222222222222 = true;
                                                                } else {
                                                                    int remaining = this._inputStream.getContentLength();
                                                                    if (remaining != 0) {
                                                                        while (this._inputStream.skip(4096L) > 0L || this._inputStream.read() >= 0) {
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                            catch (IOException e2) {
                                                                if (this._inputStream.getContentLength() > 0) {
                                                                    this._inputStream.setContentLength(0);
                                                                }
                                                                this._persistent = false;
                                                                LogSupport.ignore(log, e2);
                                                                this.exception(new HttpException(400, "Missing Content"));
                                                            }
                                                        }
                                                    }
                                                    if (!no_continue_sent222222222222222 && this._inputStream.getContentLength() > 0) {
                                                        this._inputStream.setContentLength(0);
                                                        this._persistent = false;
                                                        this.exception(new HttpException(400, "Missing Content"));
                                                    }
                                                    try {
                                                        this._outputStream.close();
                                                        bytes_written222222222222222 = this._outputStream.getBytesWritten();
                                                        this._outputStream.resetStream();
                                                        this._outputStream.addObserver(this);
                                                        this._inputStream.resetStream();
                                                    }
                                                    catch (IOException e) {
                                                        this.exception(e);
                                                    }
                                                    break block186;
                                                }
                                                if (this._response != null) {
                                                    try {
                                                        if (this._inputStream.getContentLength() > 0) {
                                                            while (this._inputStream.skip(4096L) > 0L || this._inputStream.read() >= 0) {
                                                            }
                                                        }
                                                        this._inputStream.resetStream();
                                                    }
                                                    catch (IOException e) {
                                                        LogSupport.ignore(log, e);
                                                    }
                                                    try {
                                                        this._outputStream.flush();
                                                        this._response.commit();
                                                        bytes_written222222222222222 = this._outputStream.getBytesWritten();
                                                        this._outputStream.close();
                                                        this._outputStream.resetStream();
                                                    }
                                                    catch (IOException e) {
                                                        this.exception(e);
                                                    }
                                                }
                                            }
                                            if (this._response != null) {
                                                int content_length222222222222222;
                                                if (log.isDebugEnabled()) {
                                                    log.debug((Object)("RESPONSE:\n" + this._response));
                                                }
                                                if (this._persistent && content_length222222222222222 >= 0 && bytes_written222222222222222 > 0 && content_length222222222222222 != bytes_written222222222222222) {
                                                    log.warn((Object)("Invalid length: Content-Length=" + content_length222222222222222 + " written=" + bytes_written222222222222222 + " for " + this._request.getRequestURL()));
                                                    this._persistent = false;
                                                    try {
                                                        this._outputStream.close();
                                                    }
                                                    catch (IOException e) {
                                                        log.warn((Object)"EXCEPTION ", (Throwable)e);
                                                    }
                                                }
                                            }
                                            if (stats) {
                                                this.statsRequestEnd();
                                            }
                                            if (context != null) {
                                                context.log(this._request, this._response, bytes_written222222222222222);
                                            }
                                            break block204;
                                            {
                                                catch (IOException e) {
                                                    if (this._request.getState() != 2) {
                                                        if (log.isDebugEnabled()) {
                                                            if (log.isTraceEnabled()) {
                                                                log.trace((Object)"EXCEPTION ", (Throwable)e);
                                                            } else if (log.isDebugEnabled()) {
                                                                log.debug((Object)e.toString());
                                                            }
                                                        }
                                                        this._response.destroy();
                                                        this._response = null;
                                                    } else {
                                                        this.exception(e);
                                                    }
                                                    Object var6_12 = null;
                                                    bytes_written222222222222222 = 0;
                                                    int n = content_length222222222222222 = this._response == null ? -1 : this._response.getIntField("Content-Length");
                                                    if (!this._persistent) break block188;
                                                    no_continue_sent222222222222222 = false;
                                                    try {
                                                        if (this._inputStream.getExpectContinues() != null) {
                                                            this._inputStream.setExpectContinues(null);
                                                            no_continue_sent222222222222222 = true;
                                                        } else {
                                                            int remaining = this._inputStream.getContentLength();
                                                            if (remaining != 0) {
                                                                while (this._inputStream.skip(4096L) > 0L || this._inputStream.read() >= 0) {
                                                                }
                                                            }
                                                        }
                                                    }
                                                    catch (IOException e2) {
                                                        if (this._inputStream.getContentLength() > 0) {
                                                            this._inputStream.setContentLength(0);
                                                        }
                                                        this._persistent = false;
                                                        LogSupport.ignore(log, e2);
                                                        this.exception(new HttpException(400, "Missing Content"));
                                                    }
                                                }
                                            }
                                            if (!no_continue_sent222222222222222 && this._inputStream.getContentLength() > 0) {
                                                this._inputStream.setContentLength(0);
                                                this._persistent = false;
                                                this.exception(new HttpException(400, "Missing Content"));
                                            }
                                            try {
                                                this._outputStream.close();
                                                bytes_written222222222222222 = this._outputStream.getBytesWritten();
                                                this._outputStream.resetStream();
                                                this._outputStream.addObserver(this);
                                                this._inputStream.resetStream();
                                            }
                                            catch (IOException e) {
                                                this.exception(e);
                                            }
                                            break block191;
                                        }
                                        if (this._response != null) {
                                            try {
                                                if (this._inputStream.getContentLength() > 0) {
                                                    while (this._inputStream.skip(4096L) > 0L || this._inputStream.read() >= 0) {
                                                    }
                                                }
                                                this._inputStream.resetStream();
                                            }
                                            catch (IOException e) {
                                                LogSupport.ignore(log, e);
                                            }
                                            try {
                                                this._outputStream.flush();
                                                this._response.commit();
                                                bytes_written222222222222222 = this._outputStream.getBytesWritten();
                                                this._outputStream.close();
                                                this._outputStream.resetStream();
                                            }
                                            catch (IOException e) {
                                                this.exception(e);
                                            }
                                        }
                                    }
                                    if (this._response != null) {
                                        if (log.isDebugEnabled()) {
                                            log.debug((Object)("RESPONSE:\n" + this._response));
                                        }
                                        if (this._persistent && content_length222222222222222 >= 0 && bytes_written222222222222222 > 0 && content_length222222222222222 != bytes_written222222222222222) {
                                            log.warn((Object)("Invalid length: Content-Length=" + content_length222222222222222 + " written=" + bytes_written222222222222222 + " for " + this._request.getRequestURL()));
                                            this._persistent = false;
                                            try {
                                                this._outputStream.close();
                                            }
                                            catch (IOException e) {
                                                log.warn((Object)"EXCEPTION ", (Throwable)e);
                                            }
                                        }
                                    }
                                    if (stats) {
                                        this.statsRequestEnd();
                                    }
                                    if (context != null) {
                                        context.log(this._request, this._response, bytes_written222222222222222);
                                    }
                                    break block204;
                                    {
                                        catch (Exception e) {
                                            this.exception(e);
                                            Object var6_13 = null;
                                            bytes_written222222222222222 = 0;
                                            int n = content_length222222222222222 = this._response == null ? -1 : this._response.getIntField("Content-Length");
                                            if (!this._persistent) break block193;
                                            no_continue_sent222222222222222 = false;
                                            try {
                                                if (this._inputStream.getExpectContinues() != null) {
                                                    this._inputStream.setExpectContinues(null);
                                                    no_continue_sent222222222222222 = true;
                                                } else {
                                                    int remaining = this._inputStream.getContentLength();
                                                    if (remaining != 0) {
                                                        while (this._inputStream.skip(4096L) > 0L || this._inputStream.read() >= 0) {
                                                        }
                                                    }
                                                }
                                            }
                                            catch (IOException e2) {
                                                if (this._inputStream.getContentLength() > 0) {
                                                    this._inputStream.setContentLength(0);
                                                }
                                                this._persistent = false;
                                                LogSupport.ignore(log, e2);
                                                this.exception(new HttpException(400, "Missing Content"));
                                            }
                                        }
                                    }
                                    if (!no_continue_sent222222222222222 && this._inputStream.getContentLength() > 0) {
                                        this._inputStream.setContentLength(0);
                                        this._persistent = false;
                                        this.exception(new HttpException(400, "Missing Content"));
                                    }
                                    try {
                                        this._outputStream.close();
                                        bytes_written222222222222222 = this._outputStream.getBytesWritten();
                                        this._outputStream.resetStream();
                                        this._outputStream.addObserver(this);
                                        this._inputStream.resetStream();
                                    }
                                    catch (IOException e) {
                                        this.exception(e);
                                    }
                                    break block196;
                                }
                                if (this._response != null) {
                                    try {
                                        if (this._inputStream.getContentLength() > 0) {
                                            while (this._inputStream.skip(4096L) > 0L || this._inputStream.read() >= 0) {
                                            }
                                        }
                                        this._inputStream.resetStream();
                                    }
                                    catch (IOException e) {
                                        LogSupport.ignore(log, e);
                                    }
                                    try {
                                        this._outputStream.flush();
                                        this._response.commit();
                                        bytes_written222222222222222 = this._outputStream.getBytesWritten();
                                        this._outputStream.close();
                                        this._outputStream.resetStream();
                                    }
                                    catch (IOException e) {
                                        this.exception(e);
                                    }
                                }
                            }
                            if (this._response != null) {
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)("RESPONSE:\n" + this._response));
                                }
                                if (this._persistent && content_length222222222222222 >= 0 && bytes_written222222222222222 > 0 && content_length222222222222222 != bytes_written222222222222222) {
                                    log.warn((Object)("Invalid length: Content-Length=" + content_length222222222222222 + " written=" + bytes_written222222222222222 + " for " + this._request.getRequestURL()));
                                    this._persistent = false;
                                    try {
                                        this._outputStream.close();
                                    }
                                    catch (IOException e) {
                                        log.warn((Object)"EXCEPTION ", (Throwable)e);
                                    }
                                }
                            }
                            if (stats) {
                                this.statsRequestEnd();
                            }
                            if (context != null) {
                                context.log(this._request, this._response, bytes_written222222222222222);
                            }
                            break block204;
                            {
                                catch (Error e) {
                                    this.exception(e);
                                    Object var6_14 = null;
                                    bytes_written222222222222222 = 0;
                                    int n = content_length222222222222222 = this._response == null ? -1 : this._response.getIntField("Content-Length");
                                    if (!this._persistent) break block198;
                                    no_continue_sent222222222222222 = false;
                                    try {
                                        if (this._inputStream.getExpectContinues() != null) {
                                            this._inputStream.setExpectContinues(null);
                                            no_continue_sent222222222222222 = true;
                                        } else {
                                            int remaining = this._inputStream.getContentLength();
                                            if (remaining != 0) {
                                                while (this._inputStream.skip(4096L) > 0L || this._inputStream.read() >= 0) {
                                                }
                                            }
                                        }
                                    }
                                    catch (IOException e2) {
                                        if (this._inputStream.getContentLength() > 0) {
                                            this._inputStream.setContentLength(0);
                                        }
                                        this._persistent = false;
                                        LogSupport.ignore(log, e2);
                                        this.exception(new HttpException(400, "Missing Content"));
                                    }
                                }
                            }
                            if (!no_continue_sent222222222222222 && this._inputStream.getContentLength() > 0) {
                                this._inputStream.setContentLength(0);
                                this._persistent = false;
                                this.exception(new HttpException(400, "Missing Content"));
                            }
                            try {
                                this._outputStream.close();
                                bytes_written222222222222222 = this._outputStream.getBytesWritten();
                                this._outputStream.resetStream();
                                this._outputStream.addObserver(this);
                                this._inputStream.resetStream();
                            }
                            catch (IOException e) {
                                this.exception(e);
                            }
                            break block201;
                        }
                        if (this._response != null) {
                            try {
                                if (this._inputStream.getContentLength() > 0) {
                                    while (this._inputStream.skip(4096L) > 0L || this._inputStream.read() >= 0) {
                                    }
                                }
                                this._inputStream.resetStream();
                            }
                            catch (IOException e) {
                                LogSupport.ignore(log, e);
                            }
                            try {
                                this._outputStream.flush();
                                this._response.commit();
                                bytes_written222222222222222 = this._outputStream.getBytesWritten();
                                this._outputStream.close();
                                this._outputStream.resetStream();
                            }
                            catch (IOException e) {
                                this.exception(e);
                            }
                        }
                    }
                    if (this._response != null) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("RESPONSE:\n" + this._response));
                        }
                        if (this._persistent && content_length222222222222222 >= 0 && bytes_written222222222222222 > 0 && content_length222222222222222 != bytes_written222222222222222) {
                            log.warn((Object)("Invalid length: Content-Length=" + content_length222222222222222 + " written=" + bytes_written222222222222222 + " for " + this._request.getRequestURL()));
                            this._persistent = false;
                            try {
                                this._outputStream.close();
                            }
                            catch (IOException e) {
                                log.warn((Object)"EXCEPTION ", (Throwable)e);
                            }
                        }
                    }
                    if (stats) {
                        this.statsRequestEnd();
                    }
                    if (context != null) {
                        context.log(this._request, this._response, bytes_written222222222222222);
                    }
                    break block204;
                    catch (Throwable throwable222) {
                        Object var6_15 = null;
                        bytes_written222222222222222 = 0;
                        int n = content_length222222222222222 = this._response == null ? -1 : this._response.getIntField("Content-Length");
                        if (!this._persistent) break block203;
                        no_continue_sent222222222222222 = false;
                        try {
                            if (this._inputStream.getExpectContinues() != null) {
                                this._inputStream.setExpectContinues(null);
                                no_continue_sent222222222222222 = true;
                            } else {
                                int remaining = this._inputStream.getContentLength();
                                if (remaining != 0) {
                                    while (this._inputStream.skip(4096L) > 0L || this._inputStream.read() >= 0) {
                                    }
                                }
                            }
                        }
                        catch (IOException e2) {
                            if (this._inputStream.getContentLength() > 0) {
                                this._inputStream.setContentLength(0);
                            }
                            this._persistent = false;
                            LogSupport.ignore(log, e2);
                            this.exception(new HttpException(400, "Missing Content"));
                        }
                    }
                    if (!no_continue_sent222222222222222 && this._inputStream.getContentLength() > 0) {
                        this._inputStream.setContentLength(0);
                        this._persistent = false;
                        this.exception(new HttpException(400, "Missing Content"));
                    }
                    try {
                        this._outputStream.close();
                        bytes_written222222222222222 = this._outputStream.getBytesWritten();
                        this._outputStream.resetStream();
                        this._outputStream.addObserver(this);
                        this._inputStream.resetStream();
                    }
                    catch (IOException e) {
                        this.exception(e);
                    }
                    break block205;
                }
                if (this._response != null) {
                    try {
                        if (this._inputStream.getContentLength() > 0) {
                            while (this._inputStream.skip(4096L) > 0L || this._inputStream.read() >= 0) {
                            }
                        }
                        this._inputStream.resetStream();
                    }
                    catch (IOException e) {
                        LogSupport.ignore(log, e);
                    }
                    try {
                        this._outputStream.flush();
                        this._response.commit();
                        bytes_written222222222222222 = this._outputStream.getBytesWritten();
                        this._outputStream.close();
                        this._outputStream.resetStream();
                    }
                    catch (IOException e) {
                        this.exception(e);
                    }
                }
            }
            if (this._response != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("RESPONSE:\n" + this._response));
                }
                if (this._persistent && content_length222222222222222 >= 0 && bytes_written222222222222222 > 0 && content_length222222222222222 != bytes_written222222222222222) {
                    log.warn((Object)("Invalid length: Content-Length=" + content_length222222222222222 + " written=" + bytes_written222222222222222 + " for " + this._request.getRequestURL()));
                    this._persistent = false;
                    try {
                        this._outputStream.close();
                    }
                    catch (IOException e) {
                        log.warn((Object)"EXCEPTION ", (Throwable)e);
                    }
                }
            }
            if (stats) {
                this.statsRequestEnd();
            }
            if (context != null) {
                context.log(this._request, this._response, bytes_written222222222222222);
            }
            throw throwable222;
        }
        return this._tunnel != null || this._persistent;
    }

    protected void statsRequestStart() {
        if (this._statsOn) {
            if (this._reqTime > 0L) {
                this.statsRequestEnd();
            }
            ++this._requests;
            this._reqTime = this._tmpTime = this._request.getTimeStamp();
            this._httpServer.statsGotRequest();
        }
    }

    protected void statsRequestEnd() {
        if (this._statsOn && this._reqTime > 0L) {
            this._httpServer.statsEndRequest(System.currentTimeMillis() - this._reqTime, this._response != null);
            this._reqTime = 0L;
        }
    }

    protected void recycle() {
        this._listener.persistConnection(this);
        if (this._request != null) {
            this._request.recycle(this);
        }
        if (this._response != null) {
            this._response.recycle(this);
        }
    }

    protected void destroy() {
        try {
            this.close();
        }
        catch (IOException e) {
            LogSupport.ignore(log, e);
        }
        catch (Exception e) {
            log.warn((Object)"EXCEPTION ", (Throwable)e);
        }
        if (this._request != null) {
            this._request.destroy();
        }
        if (this._response != null) {
            this._response.destroy();
        }
        if (this._inputStream != null) {
            this._inputStream.destroy();
        }
        if (this._outputStream != null) {
            this._outputStream.destroy();
        }
        this._inputStream = null;
        this._outputStream = null;
        this._request = null;
        this._response = null;
        this._handlingThread = null;
        if (this._statsOn) {
            this._tmpTime = System.currentTimeMillis();
            if (this._reqTime > 0L) {
                this._httpServer.statsEndRequest(this._tmpTime - this._reqTime, false);
            }
            this._httpServer.statsCloseConnection(this._tmpTime - this._openTime, this._requests);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

