/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd;

import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.EncodedStringInfo;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.MinimalEncoder;
import net.kano.joscar.OscarTools;
import net.kano.joscar.Writable;
import net.kano.joscar.logging.Logger;
import net.kano.joscar.logging.LoggingSystem;
import net.kano.joscar.snaccmd.CapabilityBlock;
import net.kano.joscar.snaccmd.CertificateInfo;
import net.kano.joscar.tlv.MutableTlvChain;
import net.kano.joscar.tlv.Tlv;
import net.kano.joscar.tlv.TlvChain;
import net.kano.joscar.tlv.TlvTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InfoData
implements LiveWritable {
    private static final Logger LOGGER = LoggingSystem.getLogger(InfoData.class.getName());
    public static final String NOT_AWAY = "";
    private static final int TYPE_INFO_FMT = 1;
    private static final int TYPE_INFO = 2;
    private static final int TYPE_AWAY_FMT = 3;
    private static final int TYPE_AWAY = 4;
    private static final int TYPE_CAPS = 5;
    private static final int TYPE_CERTIFICATE_INFO = 6;
    private final String userProfile;
    private final String awayMessage;
    private final List<CapabilityBlock> caps;
    private final CertificateInfo certInfo;

    public static InfoData forUserProfile(String string) {
        DefensiveTools.checkNull(string, "profile");
        return new InfoData(string, null, null, null);
    }

    public static InfoData forAwayMessage(String string) {
        DefensiveTools.checkNull(string, "awayMessage");
        return new InfoData(null, string, null, null);
    }

    public static InfoData forCapabilities(List<CapabilityBlock> list) {
        DefensiveTools.checkNull(list, "caps");
        return new InfoData(null, null, list, null);
    }

    public static InfoData forCertificateInfo(CertificateInfo certificateInfo) {
        DefensiveTools.checkNull(certificateInfo, "certInfo");
        return new InfoData(null, null, null, certificateInfo);
    }

    public static InfoData forEmptyInfo() {
        return new InfoData(null, null, null, null);
    }

    public static InfoData readInfoData(ByteBlock byteBlock) {
        return InfoData.readInfoDataFromChain(TlvTools.readChain(byteBlock));
    }

    public static InfoData readInfoDataFromChain(TlvChain tlvChain) {
        DefensiveTools.checkNull(tlvChain, "chain");
        String string = tlvChain.getString(3);
        Tlv tlv = tlvChain.getLastTlv(4);
        String string2 = tlvChain.getString(1);
        Tlv tlv2 = tlvChain.getLastTlv(2);
        Tlv tlv3 = tlvChain.getLastTlv(5);
        Tlv tlv4 = tlvChain.getLastTlv(6);
        String string3 = null;
        if (tlv != null) {
            string3 = OscarTools.getInfoString(tlv.getData(), string);
        }
        String string4 = null;
        if (tlv2 != null) {
            string4 = OscarTools.getInfoString(tlv2.getData(), string2);
        }
        List<CapabilityBlock> list = null;
        if (tlv3 != null) {
            list = CapabilityBlock.getCapabilityBlocks(tlv3.getData());
        }
        CertificateInfo certificateInfo = null;
        if (tlv4 != null) {
            certificateInfo = CertificateInfo.readCertInfoBlock(tlv4.getData());
        }
        MutableTlvChain mutableTlvChain = TlvTools.getMutableCopy(tlvChain);
        mutableTlvChain.removeTlvs(3, 4, 1, 2, 5, 6);
        if (mutableTlvChain.getTlvCount() > 0) {
            LOGGER.logWarning("Unknown TLV's in InfoData: " + mutableTlvChain);
        }
        return new InfoData(string4, string3, list, certificateInfo);
    }

    public InfoData(String string, String string2, List<CapabilityBlock> list, CertificateInfo certificateInfo) {
        this.userProfile = string;
        this.awayMessage = string2;
        this.caps = DefensiveTools.getSafeListCopy(list, "caps");
        this.certInfo = certificateInfo;
    }

    public final String getUserProfile() {
        return this.userProfile;
    }

    public final String getAwayMessage() {
        return this.awayMessage;
    }

    public final List<CapabilityBlock> getCaps() {
        return this.caps;
    }

    public final CertificateInfo getCertificateInfo() {
        return this.certInfo;
    }

    private static String getFormatString(String string) {
        return "text/x-aolrtf; charset=" + string;
    }

    private static void writeInfoTlvs(String string, OutputStream outputStream, int n, int n2) throws IOException {
        EncodedStringInfo encodedStringInfo = MinimalEncoder.encodeMinimally(string);
        ByteBlock byteBlock = ByteBlock.wrap(encodedStringInfo.getData());
        String string2 = InfoData.getFormatString(encodedStringInfo.getCharset());
        Tlv.getStringInstance(n, string2).write(outputStream);
        new Tlv(n2, byteBlock).write(outputStream);
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        Object object;
        if (this.userProfile != null) {
            InfoData.writeInfoTlvs(this.userProfile, outputStream, 1, 2);
        }
        if (this.awayMessage != null) {
            InfoData.writeInfoTlvs(this.awayMessage, outputStream, 3, 4);
        }
        if (this.caps != null) {
            object = CapabilityBlock.convertToBytes(this.caps);
            new Tlv(5, ByteBlock.wrap(object)).write(outputStream);
        }
        if (this.certInfo != null) {
            object = ByteBlock.createByteBlock(this.certInfo);
            new Tlv(6, (Writable)object).write(outputStream);
        }
    }

    public String toString() {
        String string;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("InfoData:");
        if (this.userProfile != null && this.userProfile.length() > 0) {
            string = this.userProfile;
            if (string.length() > 20) {
                string = string.substring(0, 20) + "...";
            }
            stringBuffer.append("  info: ");
            stringBuffer.append(string);
        }
        if (this.awayMessage != null && this.awayMessage.length() > 0) {
            string = this.awayMessage;
            if (string.length() > 20) {
                string = string.substring(0, 20) + "...";
            }
            stringBuffer.append("  away: ");
            stringBuffer.append(string);
        }
        if (this.caps != null && this.caps.size() > 0) {
            stringBuffer.append("  capabilities: ");
            stringBuffer.append(this.caps.size());
        }
        if (this.certInfo != null) {
            stringBuffer.append("  certinfo: ");
            stringBuffer.append(this.certInfo);
        }
        return stringBuffer.toString();
    }
}

