/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joustsim.trust;

import java.security.cert.X509Certificate;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joustsim.Screenname;
import net.kano.joustsim.trust.CertificatePairHolder;

public final class BuddyCertificateInfo
implements CertificatePairHolder {
    private final Screenname buddy;
    private final ByteBlock hash;
    private final X509Certificate encryptionCert;
    private final X509Certificate signingCert;
    private final boolean upToDate;

    public BuddyCertificateInfo(Screenname screenname, ByteBlock byteBlock) {
        this(screenname, byteBlock, null, null, false);
    }

    public BuddyCertificateInfo(Screenname screenname, ByteBlock byteBlock, X509Certificate x509Certificate, X509Certificate x509Certificate2) {
        this(screenname, byteBlock, x509Certificate, x509Certificate2, true);
    }

    public BuddyCertificateInfo(Screenname screenname, ByteBlock byteBlock, X509Certificate x509Certificate, X509Certificate x509Certificate2, boolean bl) {
        this.upToDate = bl;
        DefensiveTools.checkNull((Object)screenname, (String)"buddy");
        DefensiveTools.checkNull((Object)byteBlock, (String)"hash");
        this.buddy = screenname;
        this.hash = byteBlock;
        this.encryptionCert = x509Certificate;
        this.signingCert = x509Certificate2;
    }

    public final Screenname getBuddy() {
        return this.buddy;
    }

    public ByteBlock getCertificateInfoHash() {
        return this.hash;
    }

    public boolean hasAnyCertificates() {
        return this.encryptionCert != null || this.signingCert != null;
    }

    public boolean hasBothCertificates() {
        return this.encryptionCert != null && this.signingCert != null;
    }

    public boolean isUpToDate() {
        return this.upToDate;
    }

    public X509Certificate getEncryptionCertificate() {
        return this.encryptionCert;
    }

    public X509Certificate getSigningCertificate() {
        return this.signingCert;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BuddyCertificateInfo)) {
            return false;
        }
        BuddyCertificateInfo buddyCertificateInfo = (BuddyCertificateInfo)object;
        if (this.upToDate != buddyCertificateInfo.upToDate) {
            return false;
        }
        if (!this.buddy.equals(buddyCertificateInfo.buddy)) {
            return false;
        }
        return this.hash.equals((Object)buddyCertificateInfo.hash);
    }

    public int hashCode() {
        int n = this.buddy.hashCode();
        n = 29 * n + this.hash.hashCode();
        n = 29 * n + (this.upToDate ? 1 : 0);
        return n;
    }
}

