/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.icq;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.LEBinaryTools;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snaccmd.icq.AbstractIcqCmd;
import net.kano.joscar.snaccmd.icq.AbstractInfoCmd;

public class MetaAffiliationsInfoCmd
extends AbstractInfoCmd {
    int[] backgroundCategoryCodes;
    String[] backgrounds;
    int[] affiliationCategoryCodes;
    String[] affiliations;

    protected MetaAffiliationsInfoCmd(SnacPacket packet) {
        super(packet);
    }

    protected MetaAffiliationsInfoCmd(long uin, int id, int[] backgroundCategoryCodes, String[] backgrounds, int[] affiliationCategoryCodes, String[] affiliations) {
        super(uin, AbstractIcqCmd.CMD_META_AFFILIATIONS_INFO_CMD, id);
        DefensiveTools.checkNull(backgroundCategoryCodes, "backgroundCategoryCodes");
        DefensiveTools.checkNull(backgrounds, "backgrounds");
        DefensiveTools.checkNull(affiliationCategoryCodes, "affiliationCategoryCodes");
        DefensiveTools.checkNull(affiliations, "affiliations");
        if (backgroundCategoryCodes.length != backgroundCategoryCodes.length) {
            throw new IllegalArgumentException("Count of background category codes must equal count of backgrounds");
        }
        if (affiliationCategoryCodes.length != affiliationCategoryCodes.length) {
            throw new IllegalArgumentException("Count of affiliation category codes must equal count of affiliations");
        }
        this.backgroundCategoryCodes = backgroundCategoryCodes;
        this.backgrounds = backgrounds;
        this.affiliationCategoryCodes = affiliationCategoryCodes;
        this.affiliations = affiliations;
    }

    protected void readInfo(InputStream is) throws IOException {
        int i;
        int count = is.read();
        this.backgrounds = new String[count];
        this.backgroundCategoryCodes = new int[count];
        for (i = 0; i < count; ++i) {
            this.backgroundCategoryCodes[i] = LEBinaryTools.readUShort(is);
            this.backgrounds[i] = LEBinaryTools.readUShortLengthString(is, "US-ASCII");
        }
        count = is.read();
        this.affiliations = new String[count];
        this.affiliationCategoryCodes = new int[count];
        for (i = 0; i < count; ++i) {
            this.affiliationCategoryCodes[i] = LEBinaryTools.readUShort(is);
            this.affiliations[i] = LEBinaryTools.readUShortLengthString(is, "US-ASCII");
        }
    }

    protected void writeInfo(OutputStream out) throws IOException {
        int i;
        out.write(this.backgrounds.length);
        for (i = 0; i < this.backgrounds.length; ++i) {
            LEBinaryTools.writeUShort(out, this.backgroundCategoryCodes[i]);
            LEBinaryTools.writeUShortLengthString(out, this.backgrounds[i]);
        }
        out.write(this.affiliations.length);
        for (i = 0; i < this.affiliations.length; ++i) {
            LEBinaryTools.writeUShort(out, this.affiliationCategoryCodes[i]);
            LEBinaryTools.writeUShortLengthString(out, this.affiliations[i]);
        }
    }

    public String toString() {
        int i;
        StringBuilder result = new StringBuilder();
        result.append("MetaAffiliationsInfoCmd: backgrounds={");
        for (i = 0; i < this.backgrounds.length; ++i) {
            if (i > 0) {
                result.append(",");
            }
            result.append(this.backgroundCategoryCodes[i]).append(" :");
            result.append(this.backgrounds[i]);
        }
        result.append("} affiliations={");
        for (i = 0; i < this.affiliations.length; ++i) {
            if (i > 0) {
                result.append(",");
            }
            result.append(this.affiliationCategoryCodes[i]).append(" :");
            result.append(this.affiliations[i]);
        }
        result.append(" } in ").append(super.toString());
        return result.toString();
    }
}

