/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.snaccmd.icbm;

import java.util.List;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.flapcmd.SnacCommand;
import net.kano.joscar.flapcmd.SnacPacket;
import net.kano.joscar.snac.CmdType;
import net.kano.joscar.snac.SnacCmdFactory;
import net.kano.joscar.snaccmd.AbstractIcbm;
import net.kano.joscar.snaccmd.icbm.ParamInfoRequest;
import net.kano.joscar.snaccmd.icbm.RvResponse;
import net.kano.joscar.snaccmd.icbm.SendImIcbm;
import net.kano.joscar.snaccmd.icbm.SendRvIcbm;
import net.kano.joscar.snaccmd.icbm.SendTypingNotification;
import net.kano.joscar.snaccmd.icbm.SetParamInfoCmd;
import net.kano.joscar.snaccmd.icbm.WarnCmd;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerIcbmCmdFactory
implements SnacCmdFactory {
    protected static final List<CmdType> SUPPORTED_TYPES = DefensiveTools.asUnmodifiableList(new CmdType(4, 4), new CmdType(4, 2), new CmdType(4, 6), new CmdType(4, 20), new CmdType(4, 8), new CmdType(4, 11));

    @Override
    public List<CmdType> getSupportedTypes() {
        return SUPPORTED_TYPES;
    }

    @Override
    public SnacCommand genSnacCommand(SnacPacket snacPacket) {
        if (snacPacket.getFamily() != 4) {
            return null;
        }
        int n = snacPacket.getCommand();
        if (n == 4) {
            return new ParamInfoRequest(snacPacket);
        }
        if (n == 2) {
            return new SetParamInfoCmd(snacPacket);
        }
        if (n == 6) {
            int n2 = AbstractIcbm.getIcbmChannel(snacPacket);
            if (n2 == 1) {
                return new SendImIcbm(snacPacket);
            }
            if (n2 == 2) {
                return new SendRvIcbm(snacPacket);
            }
            return null;
        }
        if (n == 20) {
            return new SendTypingNotification(snacPacket);
        }
        if (n == 8) {
            return new WarnCmd(snacPacket);
        }
        if (n == 11) {
            return new RvResponse(snacPacket);
        }
        return null;
    }
}

