/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.flap;

import java.io.IOException;
import java.net.Socket;
import net.kano.joscar.flap.FlapProcessor;
import net.kano.joscar.net.ClientConn;
import net.kano.joscar.net.ClientConnEvent;
import net.kano.joscar.net.ClientConnListener;
import net.kano.joscar.net.ClientConnStreamHandler;
import net.kano.joscar.net.ConnDescriptor;

public class ClientFlapConn
extends ClientConn {
    private FlapProcessor flapProcessor = new FlapProcessor();

    public ClientFlapConn(ConnDescriptor connDescriptor) {
        super(connDescriptor);
        this.init();
    }

    private final void init() {
        this.setStreamHandler(new ClientConnStreamHandler(){

            public void handleStream(ClientConn clientConn, Socket socket) throws IOException {
                ClientFlapConn.this.flapProcessor.runFlapLoop();
            }
        });
        this.addConnListener(new ClientConnListener(){

            public void stateChanged(ClientConnEvent clientConnEvent) {
                ClientConn.State state = clientConnEvent.getNewState();
                if (state == ClientConn.STATE_CONNECTED) {
                    try {
                        ClientFlapConn.this.flapProcessor.attachToSocket(ClientFlapConn.this.getSocket());
                    }
                    catch (IOException iOException) {
                        ClientFlapConn.this.processError(iOException);
                        return;
                    }
                } else if (state == ClientConn.STATE_NOT_CONNECTED || state == ClientConn.STATE_FAILED) {
                    ClientFlapConn.this.flapProcessor.detach();
                }
            }
        });
    }

    public final FlapProcessor getFlapProcessor() {
        return this.flapProcessor;
    }

    public String toString() {
        return "ClientFlapConn: flapProcessor=" + this.flapProcessor;
    }
}

