/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar;

import java.io.UnsupportedEncodingException;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.kano.joscar.EncodedStringInfo;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MinimalEncoder {
    public static final String ENCODING_ASCII = "us-ascii";
    public static final String ENCODING_ISO = "iso-8859-1";
    public static final String ENCODING_UTF16 = "utf-16be";
    public static final String ENCODING_UTF8 = "utf-8";
    private static final Charset ASCII7;
    private static final Charset ISO88591;
    private static final Charset UTF16;
    private static final List<String> validCharsets;
    private String charset = validCharsets.get(0);
    private String lastCharset = null;
    private CharsetEncoder lastEncoder = null;

    public static EncodedStringInfo encodeMinimally(String string) {
        return new MinimalEncoder().encode(string);
    }

    @Nullable
    private static String getCharset(String string, Charset charset, String string2) {
        if (charset != null && charset.newEncoder().canEncode(string)) {
            return string2;
        }
        return null;
    }

    private static String getMinimalCharset(String string) {
        String string2 = MinimalEncoder.getCharset(string, ASCII7, ENCODING_ASCII);
        if (string2 != null) {
            return string2;
        }
        string2 = MinimalEncoder.getCharset(string, ISO88591, ENCODING_ISO);
        if (string2 != null) {
            return string2;
        }
        string2 = ENCODING_UTF16;
        return string2;
    }

    public final synchronized void update(String string) {
        String string2 = MinimalEncoder.getMinimalCharset(string);
        if (validCharsets.indexOf(string2) > validCharsets.indexOf(this.charset)) {
            this.charset = string2;
        }
    }

    public final synchronized void updateAll(Collection<String> collection) {
        for (String string : collection) {
            this.update(string);
        }
    }

    public final synchronized String getCharset() {
        return this.charset;
    }

    public final synchronized EncodedStringInfo encode(String string) {
        CharsetEncoder charsetEncoder;
        this.update(string);
        if (this.lastCharset == this.charset && this.lastEncoder != null) {
            charsetEncoder = this.lastEncoder;
        } else {
            charsetEncoder = this.charset == ENCODING_ASCII ? ASCII7.newEncoder() : (this.charset == ENCODING_ISO ? ISO88591.newEncoder() : UTF16.newEncoder());
            this.lastCharset = this.charset;
            this.lastEncoder = charsetEncoder;
        }
        try {
            return new EncodedStringInfo(this.charset, charsetEncoder.encode(CharBuffer.wrap(string)).array());
        }
        catch (CharacterCodingException characterCodingException) {
            try {
                return new EncodedStringInfo(ENCODING_UTF8, string.getBytes(ENCODING_UTF8));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return null;
            }
        }
    }

    public String toString() {
        return "MinimalEncoder: mincharset=" + this.charset;
    }

    static {
        validCharsets = Collections.unmodifiableList(Arrays.asList(ENCODING_ASCII, ENCODING_ISO, ENCODING_UTF16, ENCODING_UTF8));
        Charset charset = null;
        try {
            charset = Charset.forName("US-ASCII");
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            // empty catch block
        }
        ASCII7 = charset;
        Charset charset2 = null;
        try {
            charset2 = Charset.forName("ISO-8859-1");
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            // empty catch block
        }
        ISO88591 = charset2;
        Charset charset3 = null;
        try {
            charset3 = Charset.forName("UTF-16BE");
        }
        catch (UnsupportedCharsetException unsupportedCharsetException) {
            // empty catch block
        }
        UTF16 = charset3;
    }
}

