/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.openfire.plugin.rest.controller;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.jivesoftware.database.DbConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmpp.packet.JID;

public class MsgArchiveController {
    private static final Logger LOG = LoggerFactory.getLogger(MsgArchiveController.class);
    public static final MsgArchiveController INSTANCE = new MsgArchiveController();
    private static final String USER_MESSAGE_COUNT = "select COUNT(1) from ofMessageArchive a join ofPresence p on (a.sentDate > p.offlineDate) WHERE a.toJID = ? AND p.username = ?";

    public static MsgArchiveController getInstance() {
        return INSTANCE;
    }

    private MsgArchiveController() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUnReadMessagesCount(JID jid) {
        int messageCount = 0;
        Connection con = null;
        PreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            con = DbConnectionManager.getConnection();
            pstmt = con.prepareStatement(USER_MESSAGE_COUNT);
            pstmt.setString(1, jid.toBareJID());
            pstmt.setString(2, jid.getNode());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                messageCount = rs.getInt(1);
            }
            DbConnectionManager.closeConnection((ResultSet)rs, (Statement)pstmt, (Connection)con);
        }
        catch (SQLException sqle) {
            LOG.error(sqle.getMessage(), (Throwable)sqle);
        }
        finally {
            DbConnectionManager.closeConnection(rs, (Statement)pstmt, (Connection)con);
        }
        return messageCount;
    }
}

