/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BASE64EncoderStream
extends FilterOutputStream {
    private byte[] buffer = new byte[3];
    private int bufsize;
    private int count;
    private int bytesPerLine;
    private static final char[] pem_array = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};

    public BASE64EncoderStream(OutputStream outputStream, int n) {
        super(outputStream);
        this.bytesPerLine = n;
    }

    public BASE64EncoderStream(OutputStream outputStream) {
        this(outputStream, 76);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            this.write(byArray[n + n3]);
            ++n3;
        }
    }

    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    public void write(int n) throws IOException {
        this.buffer[this.bufsize++] = (byte)n;
        if (this.bufsize == 3) {
            this.encode();
            this.bufsize = 0;
        }
    }

    public void flush() throws IOException {
        if (this.bufsize > 0) {
            this.encode();
            this.bufsize = 0;
        }
        this.out.flush();
    }

    public void close() throws IOException {
        this.flush();
        this.out.close();
    }

    private void encode() throws IOException {
        if (this.count + 4 > this.bytesPerLine) {
            this.out.write(13);
            this.out.write(10);
            this.count = 0;
        }
        if (this.bufsize == 1) {
            byte by = this.buffer[0];
            int n = 0;
            boolean bl = false;
            this.out.write(pem_array[by >>> 2 & 0x3F]);
            this.out.write(pem_array[(by << 4 & 0x30) + (n >>> 4 & 0xF)]);
            this.out.write(61);
            this.out.write(61);
        } else if (this.bufsize == 2) {
            byte by = this.buffer[0];
            byte by2 = this.buffer[1];
            int n = 0;
            this.out.write(pem_array[by >>> 2 & 0x3F]);
            this.out.write(pem_array[(by << 4 & 0x30) + (by2 >>> 4 & 0xF)]);
            this.out.write(pem_array[(by2 << 2 & 0x3C) + (n >>> 6 & 3)]);
            this.out.write(61);
        } else {
            byte by = this.buffer[0];
            byte by3 = this.buffer[1];
            byte by4 = this.buffer[2];
            this.out.write(pem_array[by >>> 2 & 0x3F]);
            this.out.write(pem_array[(by << 4 & 0x30) + (by3 >>> 4 & 0xF)]);
            this.out.write(pem_array[(by3 << 2 & 0x3C) + (by4 >>> 6 & 3)]);
            this.out.write(pem_array[by4 & 0x3F]);
        }
        this.count += 4;
    }

    public static byte[] encode(byte[] byArray) {
        if (byArray.length == 0) {
            return byArray;
        }
        byte[] byArray2 = new byte[(byArray.length + 2) / 3 * 4];
        int n = 0;
        int n2 = 0;
        int n3 = byArray.length;
        while (n3 > 0) {
            byte by;
            byte by2;
            byte by3;
            if (n3 == 1) {
                by3 = byArray[n++];
                by2 = 0;
                by = 0;
                byArray2[n2++] = (byte)pem_array[by3 >>> 2 & 0x3F];
                byArray2[n2++] = (byte)pem_array[(by3 << 4 & 0x30) + (by2 >>> 4 & 0xF)];
                byArray2[n2++] = 61;
                byArray2[n2++] = 61;
            } else if (n3 == 2) {
                by3 = byArray[n++];
                by2 = byArray[n++];
                by = 0;
                byArray2[n2++] = (byte)pem_array[by3 >>> 2 & 0x3F];
                byArray2[n2++] = (byte)pem_array[(by3 << 4 & 0x30) + (by2 >>> 4 & 0xF)];
                byArray2[n2++] = (byte)pem_array[(by2 << 2 & 0x3C) + (by >>> 6 & 3)];
                byArray2[n2++] = 61;
            } else {
                by3 = byArray[n++];
                by2 = byArray[n++];
                by = byArray[n++];
                byArray2[n2++] = (byte)pem_array[by3 >>> 2 & 0x3F];
                byArray2[n2++] = (byte)pem_array[(by3 << 4 & 0x30) + (by2 >>> 4 & 0xF)];
                byArray2[n2++] = (byte)pem_array[(by2 << 2 & 0x3C) + (by >>> 6 & 3)];
                byArray2[n2++] = (byte)pem_array[by & 0x3F];
            }
            n3 -= 3;
        }
        return byArray2;
    }
}

