/*
 * Decompiled with CFR 0.152.
 */
package junit.framework;

import junit.framework.Assert;
import junit.framework.AssertionFailedError;

public class ComparisonFailure
extends AssertionFailedError {
    private String fExpected;
    private String fActual;

    public ComparisonFailure(String message, String expected, String actual) {
        super(message);
        this.fExpected = expected;
        this.fActual = actual;
    }

    public String getMessage() {
        String actual;
        String expected;
        if (this.fExpected == null || this.fActual == null) {
            return Assert.format(super.getMessage(), this.fExpected, this.fActual);
        }
        int end = Math.min(this.fExpected.length(), this.fActual.length());
        int i = 0;
        while (i < end) {
            if (this.fExpected.charAt(i) != this.fActual.charAt(i)) break;
            ++i;
        }
        int j = this.fExpected.length() - 1;
        int k = this.fActual.length() - 1;
        while (k >= i && j >= i) {
            if (this.fExpected.charAt(j) != this.fActual.charAt(k)) break;
            --k;
            --j;
        }
        if (j < i && k < i) {
            expected = this.fExpected;
            actual = this.fActual;
        } else {
            expected = this.fExpected.substring(i, j + 1);
            actual = this.fActual.substring(i, k + 1);
            if (i <= end && i > 0) {
                expected = "..." + expected;
                actual = "..." + actual;
            }
            if (j < this.fExpected.length() - 1) {
                expected = String.valueOf(expected) + "...";
            }
            if (k < this.fActual.length() - 1) {
                actual = String.valueOf(actual) + "...";
            }
        }
        return Assert.format(super.getMessage(), expected, actual);
    }
}

