/*
 * Decompiled with CFR 0.152.
 */
package com.sun.msv.datatype.xsd;

import com.sun.msv.datatype.SerializationContext;
import com.sun.msv.datatype.xsd.FloatingNumberType;
import com.sun.msv.datatype.xsd.SimpleURType;
import com.sun.msv.datatype.xsd.XSDatatype;
import org.relaxng.datatype.ValidationContext;

public class FloatType
extends FloatingNumberType {
    public static final FloatType theInstance = new FloatType();
    private static final long serialVersionUID = 1L;
    static /* synthetic */ Class class$java$lang$Float;

    private FloatType() {
        super("float");
    }

    public final XSDatatype getBaseType() {
        return SimpleURType.theInstance;
    }

    public Object _createValue(String lexicalValue, ValidationContext context) {
        return FloatType.load(lexicalValue);
    }

    public static Float load(String s) {
        try {
            if (s.equals("NaN")) {
                return new Float(Float.NaN);
            }
            if (s.equals("INF")) {
                return new Float(Float.POSITIVE_INFINITY);
            }
            if (s.equals("-INF")) {
                return new Float(Float.NEGATIVE_INFINITY);
            }
            if (s.length() == 0 || !FloatingNumberType.isDigitOrPeriodOrSign(s.charAt(0)) || !FloatingNumberType.isDigitOrPeriodOrSign(s.charAt(s.length() - 1))) {
                return null;
            }
            return Float.valueOf(s);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public Class getJavaObjectType() {
        return class$java$lang$Float == null ? (class$java$lang$Float = FloatType.class$("java.lang.Float")) : class$java$lang$Float;
    }

    public String convertToLexicalValue(Object value, SerializationContext context) {
        if (!(value instanceof Float)) {
            throw new IllegalArgumentException();
        }
        return FloatType.save((Float)value);
    }

    public static String save(Float value) {
        float v = value.floatValue();
        if (v == Float.NaN) {
            return "NaN";
        }
        if (v == Float.POSITIVE_INFINITY) {
            return "INF";
        }
        if (v == Float.NEGATIVE_INFINITY) {
            return "-INF";
        }
        return value.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        serialVersionUID = 1L;
    }
}

