/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.util.NoSuchElementException;
import org.hsqldb.Column;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.Node;
import org.hsqldb.Row;
import org.hsqldb.Table;
import org.hsqldb.Trace;
import org.hsqldb.index.RowIterator;
import org.hsqldb.lib.ArrayUtil;

public class Index {
    static final int MEMORY_INDEX = 0;
    static final int DISK_INDEX = 1;
    static final int POINTER_INDEX = 2;
    private final HsqlNameManager.HsqlName indexName;
    final boolean[] colCheck;
    private final int[] colIndex;
    private final int[] colType;
    private final boolean isUnique;
    boolean isConstraint;
    boolean isForward;
    private final boolean isExact;
    private final int visibleColumns;
    private final int colIndex_0;
    private final int colType_0;
    private Node root;
    private int depth;
    private static RowIterator emtyIterator = new IndexRowIterator(null);

    Index(HsqlNameManager.HsqlName hsqlName, Table table, int[] nArray, int[] nArray2, boolean bl, boolean bl2, boolean bl3, int n) {
        this.indexName = hsqlName;
        this.colIndex = nArray;
        this.colType = nArray2;
        this.isUnique = bl;
        this.isConstraint = bl2;
        this.isForward = bl3;
        this.colIndex_0 = this.colIndex[0];
        this.colType_0 = this.colType[0];
        this.visibleColumns = n;
        this.isExact = this.colIndex.length == this.visibleColumns;
        this.colCheck = table.getNewColumnCheckList();
        ArrayUtil.intIndexesToBooleanArray(this.colIndex, this.colCheck);
    }

    Node getRoot() {
        return this.root;
    }

    void setRoot(Node node) {
        this.root = node;
        this.depth = 0;
    }

    HsqlNameManager.HsqlName getName() {
        return this.indexName;
    }

    void setName(String string, boolean bl) throws HsqlException {
        this.indexName.rename(string, bl);
    }

    int getVisibleColumns() {
        return this.visibleColumns;
    }

    boolean isUnique() {
        return this.isUnique;
    }

    boolean isConstraint() {
        return this.isConstraint;
    }

    int[] getColumns() {
        return this.colIndex;
    }

    int size() throws HsqlException {
        int n = 0;
        Node node = this.first();
        while (node != null) {
            node = this.next(node);
            ++n;
        }
        return n;
    }

    void clearAll() {
        this.root = null;
        this.depth = 0;
    }

    void insert(Node node) throws HsqlException {
        Node node2;
        Object[] objectArray = node.getData();
        Node node3 = node2 = this.root;
        boolean bl = true;
        int n = -1;
        while (true) {
            if (node2 == null) {
                if (node3 == null) {
                    this.root = node;
                    return;
                }
                break;
            }
            Object[] objectArray2 = node2.getData();
            n = this.compareRowForInsert(objectArray, objectArray2);
            if (n == 0) {
                throw Trace.error(9, this.indexName.name);
            }
            bl = n < 0;
            node3 = node2;
            node2 = this.child(node3, bl);
        }
        this.set(node3, bl, node);
        this.balance(node3, bl);
    }

    private void balance(Node node, boolean bl) throws HsqlException {
        while (true) {
            int n = bl ? 1 : -1;
            switch (node.getBalance() * n) {
                case 1: {
                    node.setBalance(0);
                    return;
                }
                case 0: {
                    node.setBalance(-n);
                    break;
                }
                case -1: {
                    Node node2 = this.child(node, bl);
                    if (node2.getBalance() == -n) {
                        this.replace(node, node2);
                        this.set(node, bl, this.child(node2, !bl));
                        this.set(node2, !bl, node);
                        node.setBalance(0);
                        node2.setBalance(0);
                    } else {
                        Node node3 = this.child(node2, !bl);
                        this.replace(node, node3);
                        this.set(node2, !bl, this.child(node3, bl));
                        this.set(node3, bl, node2);
                        this.set(node, bl, this.child(node3, !bl));
                        this.set(node3, !bl, node);
                        int n2 = node3.getBalance();
                        node.setBalance(n2 == -n ? n : 0);
                        node2.setBalance(n2 == n ? -n : 0);
                        node3.setBalance(0);
                    }
                    return;
                }
            }
            if (node.equals(this.root)) {
                return;
            }
            bl = node.isFromLeft();
            node = node.getParent();
        }
    }

    void delete(Node node) throws HsqlException {
        Node node2;
        int n;
        Node node3;
        if (node == null) {
            return;
        }
        if (node.getLeft() == null) {
            node3 = node.getRight();
        } else if (node.getRight() == null) {
            node3 = node.getLeft();
        } else {
            Node node4 = node;
            Node node5 = node = node.getLeft();
            while ((node5 = node5.getRight()) != null) {
                node = node5;
            }
            node3 = node.getLeft();
            n = node.getBalance();
            node.setBalance(node4.getBalance());
            node4.setBalance(n);
            node2 = node.getParent();
            Node node6 = node4.getParent();
            if (node4 == this.root) {
                this.root = node;
            }
            node.setParent(node6);
            if (node6 != null) {
                if (node6.getRight().equals(node4)) {
                    node6.setRight(node);
                } else {
                    node6.setLeft(node);
                }
            }
            if (node2 == node4) {
                node4.setParent(node);
                if (node4.getLeft().equals(node)) {
                    node.setLeft(node4);
                    node.setRight(node4.getRight());
                } else {
                    node.setRight(node4);
                    node.setLeft(node4.getLeft());
                }
            } else {
                node4.setParent(node2);
                node2.setRight(node4);
                node.setRight(node4.getRight());
                node.setLeft(node4.getLeft());
            }
            node.getRight().setParent(node);
            node.getLeft().setParent(node);
            node4.setLeft(node3);
            if (node3 != null) {
                node3.setParent(node4);
            }
            node4.setRight(null);
            node = node4;
        }
        boolean bl = node.isFromLeft();
        this.replace(node, node3);
        node3 = node.getParent();
        node.delete();
        while (node3 != null) {
            node = node3;
            n = bl ? 1 : -1;
            switch (node.getBalance() * n) {
                case -1: {
                    node.setBalance(0);
                    break;
                }
                case 0: {
                    node.setBalance(n);
                    return;
                }
                case 1: {
                    node2 = this.child(node, !bl);
                    int n2 = node2.getBalance();
                    if (n2 * n >= 0) {
                        this.replace(node, node2);
                        this.set(node, !bl, this.child(node2, bl));
                        this.set(node2, bl, node);
                        if (n2 == 0) {
                            node.setBalance(n);
                            node2.setBalance(-n);
                            return;
                        }
                        node.setBalance(0);
                        node2.setBalance(0);
                        node = node2;
                        break;
                    }
                    Node node7 = this.child(node2, bl);
                    this.replace(node, node7);
                    n2 = node7.getBalance();
                    this.set(node2, bl, this.child(node7, !bl));
                    this.set(node7, !bl, node2);
                    this.set(node, !bl, this.child(node7, bl));
                    this.set(node7, bl, node);
                    node.setBalance(n2 == n ? -n : 0);
                    node2.setBalance(n2 == -n ? n : 0);
                    node7.setBalance(0);
                    node = node7;
                }
            }
            bl = node.isFromLeft();
            node3 = node.getParent();
        }
    }

    Node findNotNull(Object[] objectArray, int[] nArray, boolean bl) throws HsqlException {
        Node node = this.root;
        Node node2 = null;
        if (Index.isNull(objectArray, nArray)) {
            return null;
        }
        while (node != null) {
            Node node3;
            int n = this.compareRowNonUnique(objectArray, nArray, node.getData());
            if (n == 0) {
                if (!bl) {
                    node2 = node;
                    break;
                }
                if (node2 == node) break;
                node2 = node;
                node3 = node.getLeft();
            } else {
                node3 = n > 0 ? node.getRight() : node.getLeft();
            }
            if (node3 == null) break;
            node = node3;
        }
        return node2;
    }

    Node find(Object[] objectArray, int[] nArray) throws HsqlException {
        Node node = this.root;
        while (node != null) {
            int n = this.compareRowNonUnique(objectArray, nArray, node.getData());
            if (n == 0) {
                return node;
            }
            if (n < 0) {
                node = node.getLeft();
                continue;
            }
            node = node.getRight();
        }
        return null;
    }

    static boolean isNull(Object[] objectArray, int[] nArray) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            if (objectArray[nArray[i]] != null) continue;
            return true;
        }
        return false;
    }

    boolean isNull(Object[] objectArray) {
        int n = this.colIndex.length;
        for (int i = 0; i < n; ++i) {
            int n2 = this.colIndex[i];
            if (n2 >= this.visibleColumns || objectArray[n2] != null) continue;
            return true;
        }
        return false;
    }

    Node findFirst(Object[] objectArray) throws HsqlException {
        boolean bl;
        Node node = this.root;
        Node node2 = null;
        boolean bl2 = bl = this.isUnique && !this.isNull(objectArray);
        while (node != null) {
            int n = this.compareRowNonUnique(objectArray, this.colIndex, node.getData());
            if (n == 0) {
                node2 = node;
                if (bl) break;
                node = node.getLeft();
                continue;
            }
            if (n < 0) {
                node = node.getLeft();
                continue;
            }
            node = node.getRight();
        }
        return node2;
    }

    Node findFirst(Object object, int n) throws HsqlException {
        boolean bl = n == 21 || n == 32;
        Node node = this.root;
        int n2 = 1;
        if (n == 23) {
            n2 = 0;
        }
        if (object == null && !bl) {
            return null;
        }
        while (node != null) {
            Node node2;
            boolean bl2;
            boolean bl3 = bl2 = Column.compare(object, node.getData()[this.colIndex_0], this.colType_0) >= n2;
            if (bl2) {
                node2 = node.getRight();
                if (node2 == null) break;
                node = node2;
                continue;
            }
            node2 = node.getLeft();
            if (node2 == null) break;
            node = node2;
        }
        while (node != null) {
            Object object2 = node.getData()[this.colIndex_0];
            int n3 = Column.compare(object, object2, this.colType_0);
            if (n3 >= n2) {
                node = this.next(node);
                continue;
            }
            if (bl) {
                if (n3 == 0) break;
                node = null;
                break;
            }
            if (object2 != null) break;
            node = this.next(node);
        }
        return node;
    }

    Node findFirstNotNull() throws HsqlException {
        Object object;
        Node node = this.root;
        while (node != null) {
            Node node2;
            boolean bl;
            boolean bl2 = bl = Column.compare(null, node.getData()[this.colIndex_0], this.colType_0) >= 0;
            if (bl) {
                node2 = node.getRight();
                if (node2 == null) break;
                node = node2;
                continue;
            }
            node2 = node.getLeft();
            if (node2 == null) break;
            node = node2;
        }
        while (node != null && (object = node.getData()[this.colIndex_0]) == null) {
            node = this.next(node);
        }
        return node;
    }

    Node first() throws HsqlException {
        Node node;
        this.depth = 0;
        Node node2 = node = this.root;
        while (node2 != null) {
            node = node2;
            node2 = node.getLeft();
            ++this.depth;
        }
        return node;
    }

    RowIterator firstRow() throws HsqlException {
        return new IndexRowIterator(this);
    }

    Node next(Node node) throws HsqlException {
        if (node == null) {
            return null;
        }
        Node node2 = node.getRight();
        if (node2 != null) {
            node = node2;
            Node node3 = node.getLeft();
            while (node3 != null) {
                node = node3;
                node3 = node.getLeft();
            }
            return node;
        }
        Node node4 = node;
        for (node = node.getParent(); node != null && node4.equals(node.getRight()); node = node.getParent()) {
            node4 = node;
        }
        return node;
    }

    private Node child(Node node, boolean bl) throws HsqlException {
        return bl ? node.getLeft() : node.getRight();
    }

    private void replace(Node node, Node node2) throws HsqlException {
        if (node.equals(this.root)) {
            this.root = node2;
            if (node2 != null) {
                node2.setParent(null);
            }
        } else {
            this.set(node.getParent(), node.isFromLeft(), node2);
        }
    }

    private void set(Node node, boolean bl, Node node2) throws HsqlException {
        if (bl) {
            node.setLeft(node2);
        } else {
            node.setRight(node2);
        }
        if (node2 != null) {
            node2.setParent(node);
        }
    }

    Node search(Object[] objectArray) throws HsqlException {
        Node node = this.root;
        while (node != null) {
            int n = this.compareRow(objectArray, node.getData());
            if (n == 0) {
                return node;
            }
            if (n < 0) {
                node = node.getLeft();
                continue;
            }
            node = node.getRight();
        }
        return null;
    }

    int compareRowNonUnique(Object[] objectArray, int[] nArray, Object[] objectArray2) throws HsqlException {
        int n = Column.compare(objectArray[nArray[0]], objectArray2[this.colIndex_0], this.colType_0);
        if (n != 0) {
            return n;
        }
        int n2 = nArray.length;
        if (n2 > this.visibleColumns) {
            n2 = this.visibleColumns;
        }
        for (int i = 1; i < n2; ++i) {
            n = Column.compare(objectArray[nArray[i]], objectArray2[this.colIndex[i]], this.colType[i]);
            if (n == 0) continue;
            return n;
        }
        return 0;
    }

    private int compareRow(Object[] objectArray, Object[] objectArray2) throws HsqlException {
        int n = Column.compare(objectArray[this.colIndex_0], objectArray2[this.colIndex_0], this.colType_0);
        if (n != 0) {
            return n;
        }
        int n2 = this.colIndex.length;
        for (int i = 1; i < n2; ++i) {
            n = Column.compare(objectArray[this.colIndex[i]], objectArray2[this.colIndex[i]], this.colType[i]);
            if (n == 0) continue;
            return n;
        }
        return 0;
    }

    static int compareRows(Object[] objectArray, Object[] objectArray2, int[] nArray) throws HsqlException {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            int n2 = Column.compare(objectArray[nArray[i]], objectArray2[nArray[i]], nArray[i]);
            if (n2 == 0) continue;
            return n2;
        }
        return 0;
    }

    private int compareRowForInsert(Object[] objectArray, Object[] objectArray2) throws HsqlException {
        Object object;
        int n;
        Object object2 = objectArray[this.colIndex_0];
        int n2 = Column.compare(object2, objectArray2[this.colIndex_0], this.colType_0);
        if (n2 != 0) {
            return n2;
        }
        for (n = 1; n < this.visibleColumns; ++n) {
            object = objectArray[this.colIndex[n]];
            n2 = Column.compare(object, objectArray2[this.colIndex[n]], this.colType[n]);
            if (n2 != 0) {
                return n2;
            }
            if (object != null) continue;
            object2 = null;
        }
        if (this.isExact || this.isUnique && object2 != null) {
            return 0;
        }
        while (n < this.colIndex.length) {
            object = objectArray[this.colIndex[n]];
            n2 = Column.compare(object, objectArray2[this.colIndex[n]], this.colType[n]);
            if (n2 != 0) {
                return n2;
            }
            ++n;
        }
        return 0;
    }

    int getIndexOrderValue() {
        boolean bl = false;
        if (this.isConstraint) {
            return this.isForward ? 4 : (this.isUnique ? 0 : 1);
        }
        return 2;
    }

    public static class IndexRowIterator
    implements RowIterator {
        Index index;
        Node next;

        private IndexRowIterator(Index index) {
            this.index = index;
            if (index != null) {
                try {
                    this.next = index.first();
                }
                catch (HsqlException hsqlException) {
                    // empty catch block
                }
            }
        }

        public boolean hasNext() {
            return this.next != null;
        }

        public Row next() {
            if (this.hasNext()) {
                try {
                    Row row = this.next.getRow();
                    this.next = this.index.next(this.next);
                    return row;
                }
                catch (Exception exception) {
                    throw new NoSuchElementException();
                }
            }
            throw new NoSuchElementException();
        }
    }
}

