/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.init;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class InitUtility {
    public static native String getEnv(String var0);

    public static native void setEnv(String var0, String var1);

    public static void appendEnv(String string, String string2) {
        String string3 = InitUtility.getEnv(string);
        String string4 = string2;
        if (string3 != null) {
            string4 = string2.concat(File.pathSeparator).concat(string3);
        }
        InitUtility.setEnv(string, string4);
    }

    private static boolean isFileReadable(File file) {
        return file.isFile() && file.canRead();
    }

    public static void copyFile(String string, String string2) throws IOException {
        Object object;
        File[] fileArray;
        File file = new File(string);
        File file2 = new File(string2);
        if (!file.isDirectory()) {
            boolean bl;
            if (!InitUtility.isFileReadable(file)) {
                throw new IOException("Copy file failed. The source file is not readable: " + file);
            }
            fileArray = file2.getParentFile();
            if (!fileArray.exists() && !(bl = fileArray.mkdirs())) {
                throw new IOException("Failed to create the parent directory for: " + string2);
            }
            object = null;
            FileOutputStream fileOutputStream = null;
            try {
                int n;
                object = new FileInputStream(file);
                fileOutputStream = new FileOutputStream(file2);
                byte[] byArray = new byte[1024];
                while ((n = ((FileInputStream)object).read(byArray)) != -1) {
                    fileOutputStream.write(byArray, 0, n);
                }
            }
            catch (IOException iOException) {
                throw new IOException("Failed to copy file: " + file + " to file: " + string2);
            }
            finally {
                if (object != null) {
                    try {
                        ((FileInputStream)object).close();
                    }
                    catch (IOException iOException) {
                        throw new IOException("Failed to close the input stream during file copy.");
                    }
                }
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {
                        throw new IOException("Failed to close the ouput stream during file copy.");
                    }
                }
            }
        }
        if (file.isDirectory()) {
            fileArray = file.listFiles();
            if (!file2.exists()) {
                file2.mkdirs();
            }
            for (int i = 0; i < fileArray.length; ++i) {
                object = fileArray[i].getName();
                InitUtility.copyFile(fileArray[i].getCanonicalPath(), string2 + File.separator + (String)object);
            }
        }
    }

    static {
        System.loadLibrary("jdic");
    }
}

