/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cindy.impl;

import net.sf.cindy.Session;
import net.sf.cindy.impl.PooledDispatcherMBean;
import net.sf.cindy.impl.SimpleDispatcher;
import net.sf.cindy.spi.DispatcherSpi;
import net.sf.cindy.util.Utils;
import net.sf.cindy.util.queue.DefaultQueueThreadPool;
import net.sf.cindy.util.queue.QueueThread;

public class PooledDispatcher
implements DispatcherSpi,
PooledDispatcherMBean {
    private static int i = 0;
    private final boolean daemon;
    private final DispatcherSpi dispatcher = new SimpleDispatcher();
    private final DefaultQueueThreadPool pool;

    public PooledDispatcher() {
        this(true);
    }

    public PooledDispatcher(boolean bl) {
        this(bl, 0);
    }

    public PooledDispatcher(boolean bl, int n) {
        this.daemon = bl;
        this.pool = this.initPool();
        this.setThreadPoolSize(n);
    }

    protected DefaultQueueThreadPool initPool() {
        return new DispatchThreadPool();
    }

    public void dispatch(Session session, Runnable runnable) {
        this.pool.add(new Object[]{session, runnable});
    }

    public int getThreadPoolSize() {
        return this.pool.getThreadPoolSize();
    }

    public void setThreadPoolSize(int n) {
        this.pool.setThreadPoolSize(n);
    }

    protected class DispatchThreadPool
    extends DefaultQueueThreadPool {
        protected DispatchThreadPool() {
        }

        protected QueueThread newQueueThread() {
            QueueThread queueThread = super.newQueueThread();
            queueThread.setDaemon(PooledDispatcher.this.daemon);
            queueThread.setName(Utils.getClassSimpleName(PooledDispatcher.this.getClass()) + "-" + ++i);
            return queueThread;
        }

        protected void action(Object object) {
            Object[] objectArray = (Object[])object;
            PooledDispatcher.this.dispatcher.dispatch((Session)objectArray[0], (Runnable)objectArray[1]);
        }
    }
}

