/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.scanner;

final class IntegerQueue {
    int[] items;
    int capacity;
    int head;
    int tail;
    int numItems;

    IntegerQueue() {
        this.capacity = 128;
        this.head = 0;
        this.tail = 0;
        this.numItems = 0;
        this.items = new int[this.capacity];
    }

    IntegerQueue(int n) {
        this.capacity = n;
        this.numItems = 0;
        this.head = 0;
        this.tail = 0;
        this.items = new int[n];
    }

    final int[] reallocate(int[] nArray) {
        this.capacity = nArray.length * 2;
        int[] nArray2 = new int[nArray.length * 2];
        int n = 0;
        while (n < nArray.length) {
            nArray2[n] = nArray[n];
            ++n;
        }
        return nArray2;
    }

    final void shift() {
        int n = 0;
        while (n < this.numItems) {
            this.items[n] = this.items[n + this.head];
            ++n;
        }
        this.head = 0;
        this.tail = this.head + this.numItems;
    }

    final void add(int n) {
        if (this.tail >= this.capacity) {
            this.shift();
        }
        if (this.numItems >= this.capacity) {
            this.items = this.reallocate(this.items);
        }
        this.items[this.tail] = n;
        ++this.tail;
        ++this.numItems;
    }

    final int remove() {
        if (this.numItems == 0) {
            return -1;
        }
        int n = this.items[this.head];
        ++this.head;
        --this.numItems;
        return n;
    }

    final int get() {
        if (this.numItems == 0) {
            return -1;
        }
        return this.items[this.head];
    }

    final void clear() {
        this.numItems = 0;
        this.head = 0;
        this.tail = 0;
    }

    public static final void main(String[] stringArray) {
        IntegerQueue integerQueue = new IntegerQueue(8);
        int n = 0;
        while (n < 20) {
            integerQueue.add(n);
            System.out.println("Putting:" + n);
            ++n;
        }
        int n2 = 0;
        while (n2 < 20) {
            System.out.println("Getting:" + integerQueue.remove());
            ++n2;
        }
    }
}

