/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.dtd;

import java.io.IOException;
import weblogic.xml.babel.baseparser.BaseParser;
import weblogic.xml.babel.baseparser.ParseException;
import weblogic.xml.babel.baseparser.Space;
import weblogic.xml.babel.dtd.Declaration;
import weblogic.xml.babel.scanner.ScannerException;

public class ExternalID
extends Declaration {
    private boolean system;
    private String systemLiteral;
    private String pubidLiteral;

    public void init() {
        super.init();
    }

    public String getSystemLiteral() {
        return this.systemLiteral;
    }

    public String getPubidLiteral() {
        return this.pubidLiteral;
    }

    public void parse(BaseParser baseParser) throws IOException, ScannerException, ParseException {
        this.init();
        Space space = new Space();
        switch (baseParser.getCurrentToken().tokenType) {
            case 25: {
                baseParser.accept();
                space.parse(baseParser);
                this.systemLiteral = baseParser.getCurrentToken().getArrayAsString();
                baseParser.accept(13);
                this.system = true;
                break;
            }
            case 26: {
                baseParser.accept();
                space.parse(baseParser);
                this.systemLiteral = baseParser.getCurrentToken().getArrayAsString();
                baseParser.accept(13);
                space.parse(baseParser);
                this.pubidLiteral = baseParser.getCurrentToken().getArrayAsString();
                baseParser.accept(13);
                this.system = false;
            }
        }
    }

    public static boolean checkStarters(int n) {
        switch (n) {
            case 25: 
            case 26: {
                return true;
            }
        }
        return false;
    }

    public String toString() {
        if (this.system) {
            return "SYSTEM " + this.systemLiteral;
        }
        return "PUBLIC " + this.pubidLiteral + " " + this.systemLiteral;
    }
}

