/*
 * Decompiled with CFR 0.152.
 */
package net.kano.joscar.rvproto.rvproxy;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.kano.joscar.BinaryTools;
import net.kano.joscar.ByteBlock;
import net.kano.joscar.DefensiveTools;
import net.kano.joscar.LiveWritable;
import net.kano.joscar.rvproto.rvproxy.RvProxyCmd;

public final class RvProxyPacket
implements LiveWritable {
    public static final int PACKETVERSION_DEFAULT = 1098;
    public static final int CMDTYPE_ERROR = 1;
    public static final int CMDTYPE_INIT_SEND = 2;
    public static final int CMDTYPE_INIT_RECV = 4;
    public static final int CMDTYPE_ACK = 3;
    public static final int CMDTYPE_READY = 5;
    public static final int FLAGS_DEFAULT_FROM_SERVER = 544;
    public static final int FLAGS_DEFAULT_FROM_CLIENT = 0;
    private final int packetVersion;
    private final int commandType;
    private final int flags;
    private final ByteBlock data;
    private final int totalSize;
    private final LiveWritable dataWriter;

    public static RvProxyPacket readPacket(InputStream inputStream) throws IOException {
        int n;
        int n2;
        DefensiveTools.checkNull(inputStream, "in");
        byte[] byArray = new byte[2];
        for (int i = 0; i < byArray.length; i += n2) {
            n2 = inputStream.read(byArray, i, byArray.length - i);
            if (n2 != -1) continue;
            return null;
        }
        ByteBlock byteBlock = ByteBlock.wrap(byArray);
        n2 = BinaryTools.getUShort(byteBlock, 0);
        int n3 = n2 + 2;
        if (n2 < 10) {
            return null;
        }
        byte[] byArray2 = new byte[n2];
        for (int i = 0; i < byArray2.length; i += n) {
            n = inputStream.read(byArray2, i, byArray2.length - i);
            if (n != -1) continue;
            return null;
        }
        ByteBlock byteBlock2 = ByteBlock.wrap(byArray2);
        n = BinaryTools.getUShort(byteBlock2, 0);
        int n4 = BinaryTools.getUShort(byteBlock2, 2);
        int n5 = BinaryTools.getUShort(byteBlock2, 8);
        ByteBlock byteBlock3 = byteBlock2.subBlock(10);
        return new RvProxyPacket(n, n4, n5, byteBlock3, n3);
    }

    protected RvProxyPacket(int n, int n2, int n3, ByteBlock byteBlock, int n4) {
        DefensiveTools.checkRange(n, "packetVersion", 0);
        DefensiveTools.checkRange(n2, "cmdType", 0);
        DefensiveTools.checkRange(n3, "flags", 0);
        DefensiveTools.checkRange(n4, "totalSize", -1);
        this.packetVersion = n;
        this.commandType = n2;
        this.flags = n3;
        this.data = byteBlock;
        this.totalSize = n4;
        this.dataWriter = null;
    }

    public RvProxyPacket(final RvProxyCmd rvProxyCmd) {
        this.packetVersion = rvProxyCmd.getPacketVersion();
        this.commandType = rvProxyCmd.getCommandType();
        this.flags = rvProxyCmd.getFlags();
        this.data = null;
        this.dataWriter = new LiveWritable(){

            public void write(OutputStream outputStream) throws IOException {
                rvProxyCmd.writeCommandData(outputStream);
            }
        };
        this.totalSize = -1;
    }

    public final int getPacketVersion() {
        return this.packetVersion;
    }

    public final int getCommandType() {
        return this.commandType;
    }

    public final int getFlags() {
        return this.flags;
    }

    public final ByteBlock getCommandData() {
        return this.data;
    }

    public final int getTotalSize() {
        return this.totalSize;
    }

    public void write(OutputStream outputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(50);
        BinaryTools.writeUShort(byteArrayOutputStream, this.packetVersion);
        BinaryTools.writeUShort(byteArrayOutputStream, this.commandType);
        BinaryTools.writeUInt(byteArrayOutputStream, 0L);
        BinaryTools.writeUShort(byteArrayOutputStream, this.flags);
        if (this.dataWriter != null) {
            this.dataWriter.write(byteArrayOutputStream);
        } else if (this.data != null) {
            this.data.write(byteArrayOutputStream);
        }
        BinaryTools.writeUShort(outputStream, byteArrayOutputStream.size());
        byteArrayOutputStream.writeTo(outputStream);
    }

    public String toString() {
        return "RvProxyPacket: commandType=0x" + Integer.toHexString(this.commandType) + ", flags=0x" + Integer.toHexString(this.flags);
    }
}

