/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.proxool;

import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;

public class ConnectionResetter {
    private Log log;
    private boolean initialised;
    private Map accessorMutatorMap = new HashMap();
    private Map defaultValues = new HashMap();
    protected static final String MUTATOR_PREFIX = "set";
    private String driverName;
    protected static boolean triggerResetException;
    static /* synthetic */ Class class$java$sql$Connection;

    protected ConnectionResetter(Log log, String driverName) {
        this.log = log;
        this.driverName = driverName;
        this.addReset("getCatalog", "setCatalog");
        this.addReset("isReadOnly", "setReadOnly");
        this.addReset("getTransactionIsolation", "setTransactionIsolation");
        this.addReset("getTypeMap", "setTypeMap");
        this.addReset("getHoldability", "setHoldability");
    }

    private void addReset(String accessorName, String mutatorName) {
        try {
            Method accessor = null;
            Method mutator = null;
            Method[] methods = (class$java$sql$Connection == null ? (class$java$sql$Connection = ConnectionResetter.class$("java.sql.Connection")) : class$java$sql$Connection).getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                if (method.getName().equals(accessorName)) {
                    if (accessor == null) {
                        accessor = method;
                    } else {
                        this.log.info((Object)("Skipping ambiguous reset method " + accessorName));
                        return;
                    }
                }
                if (!method.getName().equals(mutatorName)) continue;
                if (mutator == null) {
                    mutator = method;
                    continue;
                }
                this.log.info((Object)("Skipping ambiguous reset method " + mutatorName));
                return;
            }
            if (accessor == null) {
                this.log.debug((Object)("Ignoring attempt to map reset method " + accessorName + " (probably because it isn't implemented in this JDK)"));
            } else if (mutator == null) {
                this.log.debug((Object)("Ignoring attempt to map reset method " + mutatorName + " (probably because it isn't implemented in this JDK)"));
            } else if (this.accessorMutatorMap.containsKey(accessor)) {
                this.log.warn((Object)("Ignoring attempt to map duplicate reset method " + accessorName));
            } else if (this.accessorMutatorMap.containsValue(mutator)) {
                this.log.warn((Object)("Ignoring attempt to map duplicate reset method " + mutatorName));
            } else {
                if (mutatorName.indexOf(MUTATOR_PREFIX) != 0) {
                    this.log.warn((Object)("Resetter mutator " + mutatorName + " does not start with " + MUTATOR_PREFIX + " as expected. Proxool maynot recognise that a reset is necessary."));
                }
                if (accessor.getParameterTypes().length > 0) {
                    this.log.info((Object)("Ignoring attempt to map accessor method " + accessorName + ". It must have no arguments."));
                } else if (mutator.getParameterTypes().length != 1) {
                    this.log.info((Object)("Ignoring attempt to map mutator method " + mutatorName + ". It must have exactly one argument, not " + mutator.getParameterTypes().length));
                } else {
                    this.accessorMutatorMap.put(accessor, mutator);
                }
            }
        }
        catch (Exception e) {
            this.log.error((Object)("Problem mapping " + accessorName + " and " + mutatorName), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialise(Connection connection) {
        if (!this.initialised) {
            ConnectionResetter connectionResetter = this;
            synchronized (connectionResetter) {
                if (!this.initialised) {
                    HashSet<Method> accessorsToRemove = new HashSet<Method>();
                    Iterator i = this.accessorMutatorMap.keySet().iterator();
                    while (i.hasNext()) {
                        Method accessor = (Method)i.next();
                        Method mutator = (Method)this.accessorMutatorMap.get(accessor);
                        Object value = null;
                        try {
                            value = accessor.invoke((Object)connection, null);
                            if (value != null) {
                                this.defaultValues.put(mutator, value);
                            }
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)("Remembering default value: " + accessor.getName() + "() = " + value));
                            }
                        }
                        catch (Throwable t) {
                            this.log.debug((Object)(this.driverName + " does not support " + accessor.getName() + ". Proxool doesn't mind."));
                            accessorsToRemove.add(accessor);
                        }
                        try {
                            Object[] args = new Object[]{value};
                            mutator.invoke((Object)connection, args);
                        }
                        catch (Throwable t) {
                            this.log.debug((Object)(this.driverName + " does not support " + mutator.getName() + ". Proxool doesn't mind."));
                            accessorsToRemove.add(accessor);
                        }
                    }
                    Iterator j = accessorsToRemove.iterator();
                    while (j.hasNext()) {
                        Method accessor = (Method)j.next();
                        Method mutator = (Method)this.accessorMutatorMap.get(accessor);
                        this.accessorMutatorMap.remove(accessor);
                        this.defaultValues.remove(mutator);
                    }
                    this.initialised = true;
                }
            }
        }
    }

    protected boolean reset(Connection connection, String id) {
        boolean errorsEncountered = false;
        try {
            connection.clearWarnings();
        }
        catch (SQLException e) {
            errorsEncountered = true;
            this.log.warn((Object)(id + " - Problem calling connection.clearWarnings()"), (Throwable)e);
        }
        boolean autoCommit = true;
        try {
            autoCommit = connection.getAutoCommit();
        }
        catch (SQLException e) {
            errorsEncountered = true;
            this.log.warn((Object)(id + " - Problem calling connection.getAutoCommit()"), (Throwable)e);
        }
        if (!autoCommit) {
            try {
                connection.rollback();
            }
            catch (SQLException e) {
                this.log.error((Object)"Unexpected exception whilst calling rollback during connection reset", (Throwable)e);
            }
        }
        Iterator i = this.accessorMutatorMap.keySet().iterator();
        while (i.hasNext()) {
            Method accessor = (Method)i.next();
            Method mutator = (Method)this.accessorMutatorMap.get(accessor);
            Object[] args = new Object[]{this.defaultValues.get(mutator)};
            try {
                Object currentValue = accessor.invoke((Object)connection, null);
                if (currentValue == null && args[0] == null || currentValue.equals(args[0])) continue;
                mutator.invoke((Object)connection, args);
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)(id + " - Reset: " + mutator.getName() + "(" + args[0] + ") from " + currentValue));
            }
            catch (Throwable t) {
                errorsEncountered = true;
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)(id + " - Problem resetting: " + mutator.getName() + "(" + args[0] + ")."), t);
            }
        }
        if (!autoCommit) {
            try {
                connection.setAutoCommit(true);
                this.log.debug((Object)(id + " - autoCommit reset back to true"));
            }
            catch (Throwable t) {
                errorsEncountered = true;
                this.log.warn((Object)(id + " - Problem calling connection.commit() or connection.setAutoCommit(true)"), t);
            }
        }
        if (ConnectionResetter.isTriggerResetException()) {
            this.log.warn((Object)"Triggering pretend exception during reset");
            errorsEncountered = true;
        }
        if (errorsEncountered) {
            this.log.warn((Object)(id + " - There were some problems resetting the connection (see debug output for details). It will not be used again " + "(just in case). The thread that is responsible is named '" + Thread.currentThread().getName() + "'"));
            if (!autoCommit) {
                this.log.warn((Object)(id + " - The connection was closed with autoCommit=false. That is fine, but it might indicate that " + "the problems that happened whilst trying to reset it were because a transaction is still in progress."));
            }
        }
        return !errorsEncountered;
    }

    private static boolean isTriggerResetException() {
        return triggerResetException;
    }

    protected static void setTriggerResetException(boolean triggerResetException) {
        ConnectionResetter.triggerResetException = triggerResetException;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

