/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.impl.neomedia.codec.audio.ilbc;

import com.sun.media.controls.SilenceSuppressionAdapter;
import java.awt.Component;
import java.util.Map;
import javax.media.Buffer;
import javax.media.Format;
import javax.media.format.AudioFormat;
import org.jitsi.impl.neomedia.codec.AbstractCodec2;
import org.jitsi.impl.neomedia.codec.audio.ilbc.ilbc_encoder;
import org.jitsi.service.neomedia.control.FormatParametersAwareCodec;

public class JavaEncoder
extends AbstractCodec2
implements FormatParametersAwareCodec {
    private int duration = 0;
    private ilbc_encoder enc = null;
    private int inLen;
    private int outLen;
    private byte[] prevIn;
    private int prevInLen;

    public JavaEncoder() {
        super("iLBC Encoder", AudioFormat.class, new Format[]{new AudioFormat("ilbc/rtp", 8000.0, 16, 1, 0, 1)});
        this.inputFormats = new Format[]{new AudioFormat("LINEAR", 8000.0, 16, 1, 0, 1)};
        this.addControl(new SilenceSuppressionAdapter(this, false, false));
        this.addControl(this);
    }

    @Override
    protected void doClose() {
        this.enc = null;
        this.outLen = 0;
        this.inLen = 0;
        this.prevIn = null;
        this.prevInLen = 0;
        this.duration = 0;
    }

    @Override
    protected void doOpen() {
        if (this.enc == null) {
            this.initEncoder(30);
        }
    }

    @Override
    protected int doProcess(Buffer inBuffer, Buffer outBuffer) {
        int ret;
        int inLen = inBuffer.getLength();
        byte[] in = (byte[])inBuffer.getData();
        int inOff = inBuffer.getOffset();
        if (this.prevInLen != 0 || inLen < this.inLen) {
            int bytesToCopy = this.inLen - this.prevInLen;
            if (bytesToCopy > inLen) {
                bytesToCopy = inLen;
            }
            System.arraycopy(in, inOff, this.prevIn, this.prevInLen, bytesToCopy);
            this.prevInLen += bytesToCopy;
            inBuffer.setLength(inLen - bytesToCopy);
            inBuffer.setOffset(inOff + bytesToCopy);
            inLen = this.prevInLen;
            in = this.prevIn;
            inOff = 0;
        } else {
            inBuffer.setLength(inLen - this.inLen);
            inBuffer.setOffset(inOff + this.inLen);
        }
        if (inLen >= this.inLen) {
            this.prevInLen = 0;
            int outOff = 0;
            byte[] out = JavaEncoder.validateByteArraySize(outBuffer, outOff + this.outLen, true);
            this.enc.encode(out, outOff, in, inOff);
            this.updateOutput(outBuffer, this.getOutputFormat(), this.outLen, outOff);
            outBuffer.setDuration(this.duration);
            ret = 0;
        } else {
            ret = 4;
        }
        if (inBuffer.getLength() > 0) {
            ret |= 2;
        }
        return ret;
    }

    @Override
    public Component getControlComponent() {
        return null;
    }

    @Override
    public Format getOutputFormat() {
        Format f = super.getOutputFormat();
        if (f != null && f.getClass() == AudioFormat.class) {
            AudioFormat af = (AudioFormat)f;
            f = this.setOutputFormat(new AudioFormat(af.getEncoding(), af.getSampleRate(), af.getSampleSizeInBits(), af.getChannels(), af.getEndian(), af.getSigned(), af.getFrameSizeInBits(), af.getFrameRate(), af.getDataType()){

                @Override
                public long computeDuration(long length) {
                    return JavaEncoder.this.duration;
                }
            });
        }
        return f;
    }

    private void initEncoder(int mode) {
        this.enc = new ilbc_encoder(mode);
        switch (mode) {
            case 20: {
                this.outLen = 38;
                break;
            }
            case 30: {
                this.outLen = 50;
                break;
            }
            default: {
                throw new IllegalStateException("mode");
            }
        }
        this.duration = mode * 1000000;
        this.inLen = this.enc.ULP_inst.blockl * 2;
        this.prevIn = new byte[this.inLen];
        this.prevInLen = 0;
    }

    @Override
    public void setFormatParameters(Map<String, String> fmtps) {
        String modeStr = fmtps.get("mode");
        if (modeStr != null) {
            try {
                int mode = Integer.valueOf(modeStr);
                if (mode == 20 || mode == 30) {
                    this.initEncoder(mode);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

