/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge;

import java.util.Dictionary;
import java.util.Hashtable;
import org.ice4j.ice.IceProcessingState;
import org.jitsi.videobridge.Channel;
import org.jitsi.videobridge.Conference;
import org.jitsi.videobridge.Content;
import org.jitsi.videobridge.Endpoint;
import org.jitsi.videobridge.IceUdpTransportManager;
import org.jitsi.videobridge.RtpChannel;
import org.jitsi.videobridge.eventadmin.Event;

public class EventFactory {
    public static final String CONFERENCE_CREATED_TOPIC = "org/jitsi/videobridge/Conference/CREATED";
    public static final String CHANNEL_CREATED_TOPIC = "org/jitsi/videobridge/Channel/CREATED";
    public static final String CONFERENCE_EXPIRED_TOPIC = "org/jitsi/videobridge/Conference/EXPIRED";
    public static final String CONTENT_EXPIRED_TOPIC = "org/jitsi/videobridge/Content/EXPIRED";
    public static final String CHANNEL_EXPIRED_TOPIC = "org/jitsi/videobridge/Channel/EXPIRED";
    public static final String TRANSPORT_CREATED_TOPIC = "org/jitsi/videobridge/IceUdpTransportManager/CREATED";
    public static final String TRANSPORT_CHANNEL_ADDED_TOPIC = "org/jitsi/videobridge/IceUdpTransportManager/TRANSPORT_CHANNEL_ADDED";
    public static final String CONTENT_CREATED_TOPIC = "org/jitsi/videobridge/Content/CREATED";
    public static final String TRANSPORT_CHANNEL_REMOVED_TOPIC = "org/jitsi/videobridge/IceUdpTransportManager/TRANSPORT_CHANNEL_REMOVED";
    public static final String TRANSPORT_CONNECTED_TOPIC = "org/jitsi/videobridge/IceUdpTransportManager/TRANSPORT_CHANNEL_CONNECTED";
    public static final String TRANSPORT_STATE_CHANGED_TOPIC = "org/jitsi/videobridge/IceUdpTransportManager/TRANSPORT_CHANGED";
    public static final String ENDPOINT_CREATED_TOPIC = "org/jitsi/videobridge/Endpoint/CREATED";
    public static final String ENDPOINT_DISPLAY_NAME_CHANGED_TOPIC = "org/jitsi/videobridge/Endpoint/NAME_CHANGED";
    public static final String STREAM_STARTED_TOPIC = "org/jitsi/videobridge/Endpoint/STREAM_STARTED";
    public static final String EVENT_SOURCE = "event.source";

    public static Event conferenceCreated(Conference conference) {
        return new Event(CONFERENCE_CREATED_TOPIC, EventFactory.makeProperties(conference));
    }

    public static Event contentCreated(Content content) {
        return new Event(CONTENT_CREATED_TOPIC, EventFactory.makeProperties(content));
    }

    public static Event channelCreated(Channel channel) {
        return new Event(CHANNEL_CREATED_TOPIC, EventFactory.makeProperties((Object)channel));
    }

    public static Event conferenceExpired(Conference conference) {
        return new Event(CONFERENCE_EXPIRED_TOPIC, EventFactory.makeProperties(conference));
    }

    public static Event contentExpired(Content content) {
        return new Event(CONTENT_EXPIRED_TOPIC, EventFactory.makeProperties(content));
    }

    public static Event channelExpired(Channel channel) {
        return new Event(CHANNEL_EXPIRED_TOPIC, EventFactory.makeProperties((Object)channel));
    }

    public static Event transportCreated(IceUdpTransportManager transportManager) {
        return new Event(TRANSPORT_CREATED_TOPIC, EventFactory.makeProperties(transportManager));
    }

    public static Event transportChannelAdded(Channel channel) {
        return new Event(TRANSPORT_CHANNEL_ADDED_TOPIC, EventFactory.makeProperties((Object)channel));
    }

    public static Event transportChannelRemoved(Channel channel) {
        return new Event(TRANSPORT_CHANNEL_REMOVED_TOPIC, EventFactory.makeProperties((Object)channel));
    }

    public static Event transportConnected(IceUdpTransportManager transportManager) {
        return new Event(TRANSPORT_CONNECTED_TOPIC, EventFactory.makeProperties(transportManager));
    }

    public static Event transportStateChanged(IceUdpTransportManager transportManager, IceProcessingState oldState, IceProcessingState newState) {
        Hashtable<String, IceUdpTransportManager> properties = new Hashtable<String, IceUdpTransportManager>(3);
        ((Dictionary)properties).put(EVENT_SOURCE, transportManager);
        ((Dictionary)properties).put("oldState", (IceUdpTransportManager)oldState);
        ((Dictionary)properties).put("newState", (IceUdpTransportManager)newState);
        return new Event(TRANSPORT_STATE_CHANGED_TOPIC, properties);
    }

    public static Event endpointCreated(Endpoint endpoint) {
        return new Event(ENDPOINT_CREATED_TOPIC, EventFactory.makeProperties(endpoint));
    }

    public static Event endpointDisplayNameChanged(Endpoint endpoint) {
        return new Event(ENDPOINT_DISPLAY_NAME_CHANGED_TOPIC, EventFactory.makeProperties(endpoint));
    }

    public static Event streamStarted(RtpChannel rtpChannel) {
        return new Event(STREAM_STARTED_TOPIC, EventFactory.makeProperties(rtpChannel));
    }

    protected static Dictionary makeProperties(Object source) {
        Hashtable<String, Object> properties = new Hashtable<String, Object>(1);
        ((Dictionary)properties).put(EVENT_SOURCE, source);
        return properties;
    }
}

