/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.replicatedmap.impl.client;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.replicatedmap.impl.client.ReplicatedMapPortableHook;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ReplicatedMapEntrySet<K, V>
implements Portable {
    private final Set<Map.Entry<K, V>> entrySet;

    ReplicatedMapEntrySet() {
        this.entrySet = new HashSet<Map.Entry<K, V>>();
    }

    public ReplicatedMapEntrySet(Set<Map.Entry<K, V>> entrySet) {
        this.entrySet = entrySet;
    }

    public Set<Map.Entry<K, V>> getEntrySet() {
        return this.entrySet;
    }

    @Override
    public void writePortable(PortableWriter writer) throws IOException {
        writer.writeInt("size", this.entrySet.size());
        ObjectDataOutput out = writer.getRawDataOutput();
        for (Map.Entry<K, V> entry : this.entrySet) {
            out.writeObject(entry.getKey());
            out.writeObject(entry.getValue());
        }
    }

    @Override
    public void readPortable(PortableReader reader) throws IOException {
        int size = reader.readInt("size");
        ObjectDataInput in = reader.getRawDataInput();
        for (int i = 0; i < size; ++i) {
            Object key = in.readObject();
            Object value = in.readObject();
            this.entrySet.add(new AbstractMap.SimpleImmutableEntry(key, value));
        }
    }

    @Override
    public int getFactoryId() {
        return ReplicatedMapPortableHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 12;
    }
}

