/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.scanner;

import java.io.IOException;
import weblogic.xml.babel.reader.XmlChars;
import weblogic.xml.babel.scanner.Name;
import weblogic.xml.babel.scanner.ScannerException;
import weblogic.xml.babel.scanner.ScannerState;
import weblogic.xml.babel.scanner.Space;

final class ProcessingInstruction {
    private ScannerState state;
    private Name name;
    private Space space;

    ProcessingInstruction(ScannerState scannerState) {
        this.state = scannerState;
        this.name = new Name(scannerState);
        this.space = new Space(scannerState);
    }

    void read() throws IOException, ScannerException {
        this.state.pushToken(this.state.tokenFactory.createToken(8));
        this.name.read();
        this.state.skipSpace();
        int n = 0;
        this.state.mark();
        while (true) {
            if (this.state.currentChar == '?') {
                this.state.read();
                ++n;
                while (this.state.currentChar == '?') {
                    this.state.read();
                    ++n;
                }
                if (this.state.currentChar == '>') {
                    this.state.read();
                    if (--n > 0) {
                        this.state.pushToken(this.state.tokenFactory.createToken(17, this.state.getString(n)));
                    }
                    this.state.pushToken(this.state.tokenFactory.createToken(9));
                    return;
                }
                this.state.read();
                ++n;
                continue;
            }
            if (XmlChars.isSpace(this.state.currentChar)) {
                this.state.pushToken(this.state.tokenFactory.createToken(17, this.state.getString(n)));
                this.space.read();
                n = 0;
                this.state.mark();
                continue;
            }
            this.state.checkedRead();
            ++n;
        }
    }
}

