/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.scanner;

import java.io.IOException;
import weblogic.xml.babel.reader.XmlChars;
import weblogic.xml.babel.scanner.AttributeListDeclaration;
import weblogic.xml.babel.scanner.Comment;
import weblogic.xml.babel.scanner.DTDProcessor;
import weblogic.xml.babel.scanner.ElementDeclaration;
import weblogic.xml.babel.scanner.EntityDeclaration;
import weblogic.xml.babel.scanner.ExternalID;
import weblogic.xml.babel.scanner.Name;
import weblogic.xml.babel.scanner.NotationDeclaration;
import weblogic.xml.babel.scanner.PEReference;
import weblogic.xml.babel.scanner.ScannerException;
import weblogic.xml.babel.scanner.ScannerState;
import weblogic.xml.babel.scanner.Space;

public final class DTDScanner
implements DTDProcessor {
    private ScannerState state;
    private Name name;
    private Space space;
    private PEReference perReference;
    private Comment comment;
    private ElementDeclaration elementDecl;
    private AttributeListDeclaration attListDecl;
    private ExternalID externalID;
    private EntityDeclaration entityDecl;
    private NotationDeclaration notationDecl;
    private boolean externalDTD = false;

    public DTDScanner(ScannerState scannerState) throws IOException, ScannerException {
        this.state = scannerState;
        this.name = new Name(this.state);
        this.space = new Space(this.state);
        this.perReference = new PEReference(this.state);
        this.elementDecl = new ElementDeclaration(this.state);
        this.attListDecl = new AttributeListDeclaration(this.state);
        this.externalID = new ExternalID(this.state);
        this.entityDecl = new EntityDeclaration(this.state);
        this.notationDecl = new NotationDeclaration(this.state);
        this.comment = new Comment(this.state, false);
    }

    public void read() throws IOException, ScannerException {
        if (this.externalDTD) {
            this.state.skipSpace();
            this.dispatchDTDElements();
            return;
        }
        this.state.pushToken(this.state.tokenFactory.createToken(24));
        this.state.skipSpace();
        this.name.read();
        this.state.skipSpace();
        this.externalID.read();
        this.state.skipSpace();
        this.dispatchWrappedDTDElements();
        this.state.skipSpace();
        this.state.expect('>');
        this.state.pushToken(this.state.tokenFactory.createToken(58));
    }

    public void dispatchDTDElements() throws IOException, ScannerException {
        while (this.isSeparator(this.state.currentChar) || this.startsDeclaration(this.state.currentChar)) {
            switch (this.state.currentChar) {
                case '%': {
                    this.perReference.read();
                    break;
                }
                case '<': {
                    this.readMarkupDeclaration();
                    break;
                }
                default: {
                    this.state.skipSpace();
                }
            }
        }
    }

    public void dispatchWrappedDTDElements() throws IOException, ScannerException {
        if (this.state.currentChar == '[') {
            this.state.read();
            this.dispatchDTDElements();
            this.state.skipSpace();
            this.state.expect(']');
        }
    }

    public void setExternalDTD(boolean bl) {
        this.externalDTD = bl;
    }

    private boolean isSeparator(char c) {
        return c == '%' || XmlChars.isSpace(c);
    }

    private boolean startsDeclaration(char c) {
        return c == '<';
    }

    private void readConditionalSection() throws IOException, ScannerException {
        this.state.skipDTDSpace();
        String string = this.name.stringRead();
        if (string.equals("INCLUDE")) {
            this.dispatchWrappedDTDElements();
            this.state.expect("]>");
        } else if (string.equals("IGNORE")) {
            this.ignoreConditionalSection();
        } else {
            throw new ScannerException("Conditional sections must have either the keyword INCLUDE or IGNORE in their declaration");
        }
    }

    private void ignoreConditionalSection() throws IOException, ScannerException {
        while (true) {
            if (this.state.currentChar == '<') {
                this.state.read();
                if (this.state.currentChar == '!') {
                    this.state.read();
                    if (this.state.currentChar == '[') {
                        this.state.read();
                        this.ignoreConditionalSection();
                    }
                }
            }
            if (this.state.currentChar == ']') {
                this.state.read();
                if (this.state.currentChar == ']') {
                    this.state.read();
                    if (this.state.currentChar == '>') {
                        this.state.read();
                        return;
                    }
                }
            }
            this.state.read();
        }
    }

    private void readMarkupDeclaration() throws IOException, ScannerException {
        if (this.state.currentChar == '<') {
            this.state.read();
            if (this.state.currentChar == '!') {
                this.state.read();
                if (this.state.currentChar == '-') {
                    this.state.read();
                    this.state.expect('-');
                    this.comment.read();
                    return;
                }
                if (this.state.currentChar == '[') {
                    this.state.read();
                    this.readConditionalSection();
                } else {
                    String string = this.name.stringRead();
                    if (string.equals("ELEMENT")) {
                        this.elementDecl.read();
                    } else if (string.equals("ATTLIST")) {
                        this.attListDecl.read();
                    } else if (string.equals("ENTITY")) {
                        this.entityDecl.read();
                    } else if (string.equals("NOTATION")) {
                        this.notationDecl.read();
                    } else {
                        throw new ScannerException(" '" + this.state.currentChar + "' Expected an ELEMENT,ATTLIST,NOTATION, or ENTITY declaration", this.state);
                    }
                }
            }
        }
    }

    private void skipDTDELEMENT() throws IOException, ScannerException {
        while (true) {
            if (this.state.currentChar == '\"') {
                this.skipDelimiter('\"');
            }
            if (this.state.currentChar == '\'') {
                this.skipDelimiter('\'');
            }
            if (this.state.currentChar == '>') {
                this.state.read();
                return;
            }
            this.state.checkedRead();
        }
    }

    private void skipDelimiter(char c) throws IOException, ScannerException {
        if (this.state.currentChar == c) {
            this.state.read();
            while (true) {
                if (this.state.currentChar == c) {
                    this.state.read();
                    return;
                }
                this.state.checkedRead();
            }
        }
    }
}

