/*
 * Decompiled with CFR 0.152.
 */
package weblogic.xml.babel.stream;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.xml.sax.InputSource;
import weblogic.utils.collections.CircularQueue;
import weblogic.xml.babel.adapters.ElementConsumer;
import weblogic.xml.babel.adapters.ElementFactory;
import weblogic.xml.babel.adapters.XMLInputStreamElementFactory;
import weblogic.xml.babel.baseparser.SAXElementFactory;
import weblogic.xml.babel.parsers.ValidatingXMLInputStreamParser;
import weblogic.xml.babel.parsers.XMLInputStreamParser;
import weblogic.xml.babel.parsers.XMLStreamParser;
import weblogic.xml.babel.stream.SubXMLInputStream;
import weblogic.xml.stream.ReferenceResolver;
import weblogic.xml.stream.XMLEvent;
import weblogic.xml.stream.XMLInputStream;
import weblogic.xml.stream.XMLName;
import weblogic.xml.stream.XMLStreamException;
import weblogic.xml.stream.events.ElementEvent;
import weblogic.xml.stream.events.NullEvent;

public class XMLInputStreamBase
implements XMLInputStream,
ElementConsumer {
    protected static boolean debugSubStream = false;
    protected InputSource inputSource;
    private XMLStreamParser inputStream;
    private ElementFactory elementFactory;
    protected CircularQueue elementQ;
    protected boolean open = false;
    protected ReferenceResolver resolver = null;
    protected List children = null;
    private int numChildren = 0;

    public void open(InputSource inputSource) throws XMLStreamException {
        this.open(inputSource, new XMLInputStreamElementFactory(), false, false, null);
    }

    public void openValidating(InputSource inputSource) throws XMLStreamException {
        this.open(inputSource, new XMLInputStreamElementFactory(), true, false, null);
    }

    public void openFragment(InputSource inputSource, Map map) throws XMLStreamException {
        this.open(inputSource, new XMLInputStreamElementFactory(), true, true, map);
    }

    public void open(InputSource inputSource, ElementFactory elementFactory, boolean bl, boolean bl2, Map map) throws XMLStreamException {
        this.inputSource = inputSource;
        this.elementQ = new CircularQueue(8);
        this.elementFactory = elementFactory;
        try {
            this.inputStream = !bl ? new XMLInputStreamParser(inputSource, this.elementFactory, this) : new ValidatingXMLInputStreamParser(inputSource, this.elementFactory, this, map);
            this.inputStream.setFragmentParser(bl2);
            this.inputStream.addNamespaceDeclarations(map);
            this.open = true;
        }
        catch (IOException iOException) {
            System.out.println(iOException);
            throw new XMLStreamException("Unable to instantiate the stream, the error was: " + iOException.getMessage());
        }
    }

    public void clear() {
        this.elementQ.clear();
        this.inputStream.clear();
    }

    public void recycle(Reader reader) throws XMLStreamException {
        if (this.inputStream == null || this.elementFactory == null || this.elementQ == null) {
            throw new XMLStreamException("Unable to recycle stream.");
        }
        try {
            this.clear();
            this.inputStream.recycleStream(reader);
            if (this.children != null) {
                Iterator iterator = this.children.iterator();
                while (iterator.hasNext()) {
                    XMLInputStream xMLInputStream = (XMLInputStream)iterator.next();
                    xMLInputStream.close();
                    iterator.remove();
                }
                this.children.clear();
            }
            this.children = null;
            this.numChildren = 0;
            this.open = true;
        }
        catch (IOException iOException) {
            throw new XMLStreamException((Throwable)iOException);
        }
    }

    public boolean addFirst(Object object) {
        int n = this.elementQ.size();
        if (this.elementQ.size() == 0) {
            this.add(object);
            return true;
        }
        this.add(object);
        int n2 = 0;
        while (n2 < n) {
            this.elementQ.add(this.elementQ.remove());
            ++n2;
        }
        return true;
    }

    public boolean add(Object object) {
        if (debugSubStream) {
            System.out.println("add XMLInputStreamBase[" + object + "]:numChildren[" + this.numChildren + "]");
        }
        if (debugSubStream) {
            System.out.println(this.elementQ);
        }
        ElementEvent elementEvent = (ElementEvent)object;
        this.elementQ.add(object);
        if (this.numChildren > 0) {
            this.callbackChildren(object);
        }
        return true;
    }

    public void callbackChildren(Object object) {
        if (this.children == null) {
            return;
        }
        Iterator iterator = this.children.iterator();
        while (iterator.hasNext()) {
            XMLInputStreamBase xMLInputStreamBase = (XMLInputStreamBase)iterator.next();
            ElementEvent elementEvent = (ElementEvent)object;
            if (debugSubStream) {
                System.out.println("add from Parent: [" + elementEvent + " ][ " + elementEvent.clone() + "]");
            }
            if (xMLInputStreamBase.add(elementEvent.clone())) continue;
            iterator.remove();
        }
    }

    protected XMLEvent get() throws XMLStreamException {
        XMLEvent xMLEvent = (XMLEvent)this.elementQ.remove();
        return xMLEvent;
    }

    public boolean parseSome() throws XMLStreamException {
        return this.inputStream.streamParseSome();
    }

    public boolean needsMore() {
        return this.elementQ.isEmpty();
    }

    public XMLEvent next() throws XMLStreamException {
        if (!this.open) {
            throw new XMLStreamException("Attempt to read from a stream that has not been opened");
        }
        if (this.needsMore()) {
            this.parseSome();
        }
        return this.get();
    }

    public boolean hasNext() throws XMLStreamException {
        if (!this.open) {
            return false;
        }
        if (!this.elementQ.isEmpty()) {
            return true;
        }
        return this.inputStream != null && this.inputStream.hasNext();
    }

    public void skip() throws XMLStreamException {
        if (this.hasNext()) {
            this.next();
        }
    }

    public XMLEvent peek() throws XMLStreamException {
        if (!this.elementQ.isEmpty()) {
            return (XMLEvent)this.elementQ.peek();
        }
        if (this.inputStream != null && this.inputStream.hasNext() && this.inputStream.streamParseSome()) {
            return (XMLEvent)this.elementQ.peek();
        }
        return new NullEvent();
    }

    public void close() throws XMLStreamException {
        this.inputSource = null;
        this.open = false;
        if (this.children != null) {
            Iterator iterator = this.children.iterator();
            while (iterator.hasNext()) {
                XMLInputStream xMLInputStream = (XMLInputStream)iterator.next();
                xMLInputStream.close();
                iterator.remove();
            }
            this.children.clear();
        }
        this.children = null;
        this.numChildren = 0;
    }

    public boolean skip(int n) throws XMLStreamException {
        while (this.hasNext()) {
            XMLEvent xMLEvent = this.peek();
            if (xMLEvent == null) {
                return false;
            }
            if (xMLEvent.getType() == 128) {
                return false;
            }
            if ((xMLEvent.getType() & n) != 0) {
                return true;
            }
            this.next();
        }
        return false;
    }

    protected boolean matchName(XMLName xMLName, XMLName xMLName2) {
        if (xMLName == null || xMLName2 == null) {
            return false;
        }
        if (xMLName.getNamespaceUri() != null && xMLName.getNamespaceUri().equals(xMLName2.getNamespaceUri())) {
            if (xMLName.getLocalName() != null) {
                return xMLName.getLocalName().equals(xMLName2.getLocalName());
            }
            return true;
        }
        if (xMLName.getLocalName() != null) {
            return xMLName.getLocalName().equals(xMLName2.getLocalName());
        }
        return false;
    }

    public boolean skip(XMLName xMLName) throws XMLStreamException {
        while (this.hasNext()) {
            XMLEvent xMLEvent = this.peek();
            switch (xMLEvent.getType()) {
                case 2: 
                case 4: {
                    if (!this.matchName(xMLName, xMLEvent.getName())) break;
                    return true;
                }
            }
            this.next();
        }
        return false;
    }

    public boolean skip(XMLName xMLName, int n) throws XMLStreamException {
        while (this.skip(xMLName)) {
            XMLEvent xMLEvent = this.peek();
            if ((xMLEvent.getType() & n) != 0) {
                return true;
            }
            this.next();
        }
        return false;
    }

    public void initChild(XMLInputStreamBase xMLInputStreamBase) {
        int n = this.elementQ.size();
        if (debugSubStream) {
            System.out.println("XMLInputStreamBase:initChild:[" + n + "]");
        }
        if (debugSubStream) {
            System.out.println(this.elementQ);
        }
        int n2 = 0;
        while (n2 < n) {
            ElementEvent elementEvent = (ElementEvent)this.elementQ.remove();
            this.elementQ.add(elementEvent);
            ElementEvent elementEvent2 = (ElementEvent)elementEvent.clone();
            xMLInputStreamBase.add(elementEvent2);
            if (debugSubStream) {
                System.out.println("XMLInputStreamBase:initChild:[" + elementEvent2 + "]");
            }
            ++n2;
        }
    }

    public void addChild(XMLInputStreamBase xMLInputStreamBase) {
        if (debugSubStream) {
            System.out.println("BEGIN Adding and init child");
        }
        if (this.children == null) {
            this.children = new ArrayList();
        }
        ++this.numChildren;
        this.initChild(xMLInputStreamBase);
        this.children.add(xMLInputStreamBase);
        if (debugSubStream) {
            System.out.println("END Adding and init child");
        }
    }

    public void removeChild(XMLInputStreamBase xMLInputStreamBase) {
        if (this.children != null && this.children.remove(xMLInputStreamBase)) {
            --this.numChildren;
        }
    }

    public XMLInputStream getSubStream() throws XMLStreamException {
        return new SubXMLInputStream(this);
    }

    public void skipElement() throws XMLStreamException {
        int n = 0;
        boolean bl = false;
        while (this.hasNext() && !bl) {
            XMLEvent xMLEvent = this.next();
            switch (xMLEvent.getType()) {
                case 2: {
                    ++n;
                    break;
                }
                case 4: {
                    if (--n > 0) break;
                    bl = true;
                    break;
                }
                case 128: 
                case 512: {
                    bl = true;
                }
            }
        }
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        this.resolver = referenceResolver;
    }

    public ReferenceResolver getReferenceResolver() {
        return this.resolver;
    }

    public static void main(String[] stringArray) throws Exception {
        XMLInputStreamBase xMLInputStreamBase = new XMLInputStreamBase();
        xMLInputStreamBase.openValidating(SAXElementFactory.createInputSource(stringArray[0]));
        while (xMLInputStreamBase.hasNext()) {
            XMLEvent xMLEvent = xMLInputStreamBase.next();
            System.out.print("EVENT: " + xMLEvent.getTypeAsString() + " [");
            System.out.print(xMLEvent);
            System.out.println("]");
        }
    }
}

