/*
 * Decompiled with CFR 0.152.
 */
package com.bea.xml.stream.test;

import com.bea.xml.stream.XMLEventPlayer;
import com.bea.xml.stream.XMLStreamPlayer;
import com.bea.xml.stream.filters.NameFilter;
import com.bea.xml.stream.test.BaseTestCase;
import com.bea.xml.stream.test.EqualityResult;
import com.bea.xml.stream.test.Util;
import java.io.FileNotFoundException;
import java.io.FileReader;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class NameFilterTest
extends BaseTestCase {
    protected String input;
    protected String master;
    protected XMLInputFactory factory;
    protected NameFilter f;
    static /* synthetic */ Class class$com$bea$xml$stream$test$NameFilterTest;

    public static void main(String[] args) {
        NameFilterTest nTest = new NameFilterTest();
        nTest.setParams(args[0]);
        TestRunner.run((Test)NameFilterTest.suite());
    }

    public void setParams(String in) {
        this.logger.info((Object)"Running NameFilter Test");
        this.input = in + ".xml";
    }

    protected void setUp() {
        if (this.input == null) {
            this.input = "./files/foo2.xml";
        }
        if (this.master == null) {
            this.master = "./files/foo2_filtered_apple_a.stream";
        }
        this.factory = XMLInputFactory.newInstance();
        this.f = new NameFilter(new QName("apple", "a"));
    }

    public static Test suite() {
        return new TestSuite(class$com$bea$xml$stream$test$NameFilterTest == null ? (class$com$bea$xml$stream$test$NameFilterTest = NameFilterTest.class$("com.bea.xml.stream.test.NameFilterTest")) : class$com$bea$xml$stream$test$NameFilterTest);
    }

    public void testStreamEquals() throws XMLStreamException, FileNotFoundException {
        this.logger.info((Object)"Can the XMLStreamReader properly parse the XML document with filter?");
        XMLStreamReader r1 = this.factory.createFilteredReader(this.factory.createXMLStreamReader(new FileReader(this.input)), this.f);
        XMLStreamPlayer r2 = new XMLStreamPlayer(new FileReader(this.master));
        Util util = new Util();
        if (r1 == null) {
            Assert.fail((String)"Reader is null");
        }
        EqualityResult r = util.equals(r1, r2);
        this.logger.info((Object)r.toString());
        Assert.assertTrue((boolean)r.getValue());
        r1.close();
        r2.close();
        this.logger.info((Object)("XMLStreamReader successfully parsed " + this.input + " with filter"));
    }

    public void testEventEquals() throws XMLStreamException, FileNotFoundException {
        this.logger.info((Object)"Can the XMLEventReader properly parse the XML document with filter?");
        XMLEventReader e1 = this.factory.createFilteredReader(this.factory.createXMLEventReader(new FileReader(this.input)), this.f);
        XMLEventPlayer e2 = new XMLEventPlayer(new XMLStreamPlayer(new FileReader(this.master)));
        Util util = new Util();
        if (e1 == null) {
            Assert.fail((String)"Reader is null");
        }
        EqualityResult r = util.equals(e1, e2);
        this.logger.info((Object)r.toString());
        System.out.println("----------------------------------" + r.toString());
        Assert.assertTrue((boolean)r.getValue());
        this.logger.info((Object)("XMLEventReader successfully parsed " + this.input + " with filter"));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

