/*
 * Decompiled with CFR 0.152.
 */
package com.lotus.sametime.core.util.enc;

import java.math.BigInteger;
import java.util.Random;

public class DiffieHellman {
    public static BigInteger Default_Base;
    public static BigInteger Default_Modulus;
    private BigInteger b;
    private BigInteger a;

    static {
        Default_Modulus = new BigInteger("CF84AFCE86DDFA527F136D10357528EEFBA0AFEF808F29174E3B6A9E970001717C8F106C41C161A6CE91057B34DA62CBB87BFDC1B35C1B910FEA72249D566B9F", 16);
        Default_Base = new BigInteger("3");
    }

    private int a() {
        int n2 = this.a.bitCount();
        if (n2 < 5) {
            return 0;
        }
        return 2 * (int)(2.4 * Math.pow(n2, 0.3333333333333333) * Math.pow(Math.log(n2), 0.6666666666666666) - 5.0);
    }

    public byte[] generateAgreedValue(byte[] byArray, byte[] byArray2) {
        BigInteger bigInteger = new BigInteger(1, byArray2);
        BigInteger bigInteger2 = new BigInteger(1, byArray);
        BigInteger bigInteger3 = bigInteger.modPow(bigInteger2, this.a);
        return bigInteger3.toByteArray();
    }

    public DiffieHellman(BigInteger bigInteger, BigInteger bigInteger2) {
        this.a = bigInteger;
        this.b = bigInteger2;
    }

    public byte[] generatePublicKey(byte[] byArray) {
        BigInteger bigInteger = new BigInteger(1, byArray);
        BigInteger bigInteger2 = this.b.modPow(bigInteger, this.a);
        return bigInteger2.toByteArray();
    }

    public byte[] generatePrivateKey(Random random) {
        BigInteger bigInteger = new BigInteger(this.a(), random);
        return bigInteger.toByteArray();
    }
}

