/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jqql.packets;

import java.nio.ByteBuffer;
import net.sf.jqql.beans.QQUser;
import net.sf.jqql.packets.PacketParseException;
import net.sf.jqql.packets._08OutPacket;

public abstract class _08BasicOutPacket
extends _08OutPacket {
    private int qqNum;

    protected _08BasicOutPacket(char c, boolean bl, QQUser qQUser) {
        super((byte)2, c, bl, qQUser);
    }

    protected _08BasicOutPacket(ByteBuffer byteBuffer, QQUser qQUser) throws PacketParseException {
        this(byteBuffer, byteBuffer.limit() - byteBuffer.position(), qQUser);
    }

    protected _08BasicOutPacket(ByteBuffer byteBuffer, int n, QQUser qQUser) throws PacketParseException {
        super(byteBuffer, n, qQUser);
    }

    protected boolean validateHeader() {
        return this.qqNum == this.user.getQQ();
    }

    protected byte[] getBodyBytes(ByteBuffer byteBuffer, int n) {
        int n2 = n - 11 - 1;
        if (!this.user.isUdp()) {
            n2 -= 2;
        }
        byte[] byArray = new byte[n2];
        byteBuffer.get(byArray);
        return byArray;
    }

    protected void postFill(ByteBuffer byteBuffer, int n) {
        if (!this.user.isUdp()) {
            int n2 = byteBuffer.position() - n;
            byteBuffer.putChar(n, (char)n2);
        }
    }

    protected int getLength(int n) {
        return 12 + n + (this.user.isUdp() ? 0 : 2);
    }

    protected void parseTail(ByteBuffer byteBuffer) throws PacketParseException {
        byteBuffer.get();
    }

    public String getPacketName() {
        return "Unknown Outcoming _08Packet - Basic Family";
    }

    protected void putHead(ByteBuffer byteBuffer) {
        if (!this.user.isUdp()) {
            byteBuffer.putChar('\u0000');
        }
        byteBuffer.put(this.getHeader());
        byteBuffer.putChar(this.source);
        byteBuffer.putChar(this.command);
        byteBuffer.putChar(this.sequence);
        byteBuffer.putInt(this.user.getQQ());
    }

    protected void putTail(ByteBuffer byteBuffer) {
        byteBuffer.put((byte)3);
    }

    protected void parseHeader(ByteBuffer byteBuffer) throws PacketParseException {
        if (!this.user.isUdp()) {
            byteBuffer.getChar();
        }
        this.header = byteBuffer.get();
        this.source = byteBuffer.getChar();
        this.command = byteBuffer.getChar();
        this.sequence = byteBuffer.getChar();
        this.qqNum = byteBuffer.getInt();
    }

    protected int getHeadLength() {
        return 11 + (this.user.isUdp() ? 0 : 2);
    }

    protected int getTailLength() {
        return 1;
    }

    public String toString() {
        return "\u5305\u540d: " + this.getPacketName() + " \u5e8f\u53f7: " + this.sequence;
    }

    public byte[] getDecryptKey(byte[] byArray) {
        return this.user.getSessionKey();
    }

    public byte[] getFallbackDecryptKey(byte[] byArray) {
        return this.user.getPasswordKey();
    }

    public byte[] getEncryptKey(byte[] byArray) {
        return this.user.getSessionKey();
    }

    public int getFamily() {
        return 1;
    }
}

