/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jqql.net;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import net.sf.jqql.QQClient;
import net.sf.jqql.net.IConnectionPolicy;
import net.sf.jqql.packets.ErrorPacket;
import net.sf.jqql.packets.PacketHelper;
import net.sf.jqql.packets.PacketParseException;
import net.sf.jqql.packets._08InPacket;
import net.sf.jqql.packets._08OutPacket;

public class ConnectionPolicy
implements IConnectionPolicy {
    QQClient client;
    int supportedFamily;
    int relocateFamily;
    PacketHelper helper;
    String id;
    private InetSocketAddress proxy;
    private String proxyUsername;
    private String proxyPassword;

    public ConnectionPolicy(QQClient qQClient, String string, int n, int n2) {
        this.client = qQClient;
        this.id = string;
        this.supportedFamily = n;
        this.relocateFamily = n2;
        this.helper = new PacketHelper(n);
    }

    public boolean relocate(ByteBuffer byteBuffer) {
        return this.helper.relocate(this.relocateFamily, byteBuffer);
    }

    public ErrorPacket createErrorPacket(int n, String string) {
        ErrorPacket errorPacket = new ErrorPacket(n, this.client.getUser());
        errorPacket.setFamily(this.supportedFamily);
        errorPacket.connectionId = string;
        return errorPacket;
    }

    public void pushResend(_08OutPacket _08OutPacket2, String string) {
        this.client.addResendPacket(_08OutPacket2, string);
    }

    public void flush() {
        this.client.getConnectionPool().flush();
    }

    public void pushIn(_08InPacket _08InPacket2) {
        this.client.addIncomingPacket(_08InPacket2, this.id);
    }

    public _08InPacket parseIn(ByteBuffer byteBuffer, boolean bl) throws PacketParseException {
        return this.helper.parseIn(this.supportedFamily, byteBuffer, this.client.getUser(), bl);
    }

    public void putSent(_08OutPacket _08OutPacket2) {
        this.helper.putSent(_08OutPacket2);
    }

    public boolean isReplied(_08OutPacket _08OutPacket2, boolean bl) {
        return this.helper.isReplied(_08OutPacket2, bl);
    }

    public _08OutPacket retrieveSent(_08InPacket _08InPacket2) {
        return this.helper.retrieveSent(_08InPacket2);
    }

    public int getSupportedFamily() {
        return this.supportedFamily;
    }

    public int getRelocateFamily() {
        return this.relocateFamily;
    }

    public String getConnectionId() {
        return this.id;
    }

    public InetSocketAddress getProxy() {
        return this.proxy;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxy(InetSocketAddress inetSocketAddress) {
        this.proxy = inetSocketAddress;
    }

    public void setProxyPassword(String string) {
        this.proxyPassword = string;
    }

    public void setProxyUsername(String string) {
        this.proxyUsername = string;
    }
}

